use strict;
use warnings;
use Test::More;
use Digest::BLAKE qw(blake_224 blake_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::BLAKE->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            blake_224_hex($data), $digest,
            "blake_224_hex: $len bits of $msg"
        );
        ok(
            blake_224($data) eq pack('H*', $digest),
            "blake_224: $len bits of $msg"
        );
    }

    my $md = Digest::BLAKE->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|7dc5313b1c04512a174bd6503b89607aecbee0903d40a8a569c94eed
00|615b9bd1077a8270d4f647799ffaaf87c03d72efd37e4947fcf01cca
C0|6a829dca3a3d0d35762d7b0f9a2c8379c32415c87a8ad773fefec19f
C0|5478a106aca2b539d5bd52db8b19717d436ca27c14ef99ed565bc4a7
80|2b10ebc335731de6148ce84ed05a2685b9c274105c6aaf1dd59ef000
48|a49e36fd01041a0a86eb12d7f110bf4ef798b686fff48e5abc6bc8b4
50|57036a8ad47cb24e0f329ef991b571211f171bf86f546aa068577cb5
98|82417e4fdb2b426d125415b10fe7dae7e944291f8daeb049b80e93a0
CC|5e21c1e375c7bc822046fad96910c95031bd4262ada71b4c91052fea
9800|30df15eb42922a41c1ef59102115d2f656e94f39fd1eeca115a9a07a
9D40|5c6c22d948c98644057c9ad31107164ecda652f4c51abd8cc4652ee6
AA80|276babfb45f0da4ddce7012d009122cdb974702cce1fcc83e0b254af
9830|5dd804d86cc32084c81caea4ee5b472b2ba6e8c17eb2ff982e9e885b
5030|e3d122c703be5ebca4ecc1860a8f50cff518c3984d3605f3c98bb52b
4D24|35e05b766f7fcfb136e62cef59400b3e776f74e69a16912a9e7a9d78
CBDE|227804938f7d63d96a54778f71bfb7421dcf056ddd78ab8b739a7a2e
41FB|195707e8ce71fb91c2c82ccf78022609a598bd80c9a505ef035314db
4FF400|86113100dd674ebf5d0c36b609d9ab8bbd8ecb5d54b0a5aaea9d5e1d
FD0440|608997b3ae1483e0298a08d816029d112124743cde703dd0350edbe9
424D00|89f898843d7ab0bb50ac8f6d1139e18aca0ef1d4e95b089ec2172685
3FDEE0|280cee22ba45b2ff9dfa70462cd34c106a24842c6a247f74ade67158
335768|780f1fb7fd80898a10e9c6d63d212372bf7f6b3cd6a6c231ee5daa9b
051E7C|0296e4a199194d5b65aa40fb0ec33870e36daa3e2e962d2c5b6f3a99
717F8C|1e95aa999a1a68c1c5191d2365664415344ed1673cb6c12a849abf0a
1F877C|4239b4afa926f2269b117059dc0310033c9c85acea1a031f97cd4e2a
EB35CF80|dfd3f804fbc9ad5805fc5b529c1d0564e96454710d0b21d561357ac5
B406C480|e1fd87c6396d42e19713290547cc324268c27b7fa40398ed3797b148
CEE88040|dfebe7b56e9247d4023cecda04c28e1fc4eb6049fa27a747f75d832d
C584DB70|79737f20528fac047c7ea52a2a295bd7ce15087773747cb450be6874
53587BC8|de42f62c6eeddc5bd80fdf52edcf64754d875bb2b214d5e715833270
69A305B0|328a913d190fa087c58958a321138400e5a9e9a8983c9853c0b932ea
C9375ECE|efa18a9d2ada4755c260482989442f21b8c5b2e09155517e201d269e
C1ECFDFC|9cd80af6d0181b831e1879959f287735c9cbf5d1e480e7341266d6f0
8D73E8A280|2849a31c29e378fa9eef77ad80043e822c70cde973cb99a4a7f21a07
06F2522080|d9315ee5d1e33178363ddfdd7d595e0ba4a6d82522500e27ed3075ae
3EF6C36F20|40663b7856cfb2d57987a85dbd76c447dcf582481912c9a373924127
0127A1D340|61a5fdead981d711d72d3dc5cfe7f8c40916ce16a42a97cb7b8a016e
6A6AB6C210|a63d8d4a5239c7132031c1ca6527ebe3e7d6d647124fafdf5f123de2
AF3175E160|3e7c863db3e16c2350a44e161a2aa3810764cf523c62ab71999a9d24
B66609ED86|e3b7ce19f60913cd5aa1d43bd92de285f72163e0f9453f4e5f21bf52
21F134AC57|9e908983741757ff632c01f2b2c4d7f1ec8e642d112c212ba9739fd1
3DC2AADFFC80|4e1a8c57c3713217530a5f667b37f6bc23939d2fb43dea9745f50068
9202736D2240|a3c9ece5a71fed7c2e58bfd0b67fcf286668c2bcc31826c1b4cd6d59
F219BD629820|f087f490d55044aa4d147f79d0f1e980fdba1d78cacb5999ff9e67ca
F3511EE2C4B0|49da5bdbc1fe187a28cbd493f383108ff1c6bcd71b3fef2c742074a5
3ECAB6BF7720|2143ed11184621cb64716a451688291bd0799574f2a28537885540be
CD62F688F498|0874dba67485be94b9f5a500fade53c94622573059a7fd78f50d0309
C2CBAA33A9F8|2e14b39f6de58b0fdd67b9c45eae6c3ff71a363defea06975410e25a
C6F50BB74E29|6d6d952053aead200de9daa856c2993a7a7fa4a15b3924fb77dbb384
79F1B4CCC62A00|ad93ea3f245493cf2b660d6f5fe82b8bfb0d3394854e88c2704c98c2
