package Unicode::Collate::CJK::Big5;

use 5.006;
use strict;
use warnings;

our $VERSION = '1.18';

my %u2p;
my $wt = 0x8000;

while (<DATA>) {
    last if /^__END__/;
    my @c = split;
    for my $c (@c) {
	next if !$c;
	$u2p{hex($c)} = $wt;
	$wt++;
    }
}

sub weightBig5 {
    my $u = shift;
    return exists $u2p{$u} ? $u2p{$u} : undef;
}

1;
__DATA__
5159 515B 515E 515D 5161 5163 55E7 74E9 7CCE 4E00
4E59 4E01 4E03 4E43 4E5D 4E86 4E8C 4EBA 513F 5165
516B 51E0 5200 5201 529B 5315 5341 535C 53C8 4E09
4E0B 4E08 4E0A 4E2B 4E38 51E1 4E45 4E48 4E5F 4E5E
4E8E 4EA1 5140 5203 52FA 5343 53C9 53E3 571F 58EB
5915 5927 5973 5B50 5B51 5B53 5BF8 5C0F 5C22 5C38
5C71 5DDD 5DE5 5DF1 5DF2 5DF3 5DFE 5E72 5EFE 5F0B
5F13 624D 4E11 4E10 4E0D 4E2D 4E30 4E39 4E4B 5C39
4E88 4E91 4E95 4E92 4E94 4EA2 4EC1 4EC0 4EC3 4EC6
4EC7 4ECD 4ECA 4ECB 4EC4 5143 5141 5167 516D 516E
516C 5197 51F6 5206 5207 5208 52FB 52FE 52FF 5316
5339 5348 5347 5345 535E 5384 53CB 53CA 53CD 58EC
5929 592B 592A 592D 5B54 5C11 5C24 5C3A 5C6F 5DF4
5E7B 5EFF 5F14 5F15 5FC3 6208 6236 624B 624E 652F
6587 6597 65A4 65B9 65E5 66F0 6708 6728 6B20 6B62
6B79 6BCB 6BD4 6BDB 6C0F 6C34 706B 722A 7236 723B
7247 7259 725B 72AC 738B 4E19 4E16 4E15 4E14 4E18
4E3B 4E4D 4E4F 4E4E 4EE5 4ED8 4ED4 4ED5 4ED6 4ED7
4EE3 4EE4 4ED9 4EDE 5145 5144 5189 518A 51AC 51F9
51FA 51F8 520A 52A0 529F 5305 5306 5317 531D 4EDF
534A 5349 5361 5360 536F 536E 53BB 53EF 53E4 53F3
53EC 53EE 53E9 53E8 53FC 53F8 53F5 53EB 53E6 53EA
53F2 53F1 53F0 53E5 53ED 53FB 56DB 56DA 5916 592E
5931 5974 5976 5B55 5B83 5C3C 5DE8 5DE7 5DE6 5E02
5E03 5E73 5E7C 5F01 5F18 5F17 5FC5 620A 6253 6254
6252 6251 65A5 65E6 672E 672C 672A 672B 672D 6B63
6BCD 6C11 6C10 6C38 6C41 6C40 6C3E 72AF 7384 7389
74DC 74E6 7518 751F 7528 7529 7530 7531 7532 7533
758B 767D 76AE 76BF 76EE 77DB 77E2 77F3 793A 79BE
7A74 7ACB 4E1E 4E1F 4E52 4E53 4E69 4E99 4EA4 4EA6
4EA5 4EFF 4F09 4F19 4F0A 4F15 4F0D 4F10 4F11 4F0F
4EF2 4EF6 4EFB 4EF0 4EF3 4EFD 4F01 4F0B 5149 5147
5146 5148 5168 5171 518D 51B0 5217 5211 5212 520E
5216 52A3 5308 5321 5320 5370 5371 5409 540F 540C
540A 5410 5401 540B 5404 5411 540D 5408 5403 540E
5406 5412 56E0 56DE 56DD 5733 5730 5728 572D 572C
572F 5729 5919 591A 5937 5938 5984 5978 5983 597D
5979 5982 5981 5B57 5B58 5B87 5B88 5B85 5B89 5BFA
5C16 5C79 5DDE 5E06 5E76 5E74 5F0F 5F1B 5FD9 5FD6
620E 620C 620D 6210 6263 625B 6258 6536 65E9 65E8
65EC 65ED 66F2 66F3 6709 673D 6734 6731 6735 6B21
6B64 6B7B 6C16 6C5D 6C57 6C59 6C5F 6C60 6C50 6C55
6C61 6C5B 6C4D 6C4E 7070 725F 725D 767E 7AF9 7C73
7CF8 7F36 7F8A 7FBD 8001 8003 800C 8012 8033 807F
8089 808B 808C 81E3 81EA 81F3 81FC 820C 821B 821F
826E 8272 827E 866B 8840 884C 8863 897F 9621 4E32
4EA8 4F4D 4F4F 4F47 4F57 4F5E 4F34 4F5B 4F55 4F30
4F50 4F51 4F3D 4F3A 4F38 4F43 4F54 4F3C 4F46 4F63
4F5C 4F60 4F2F 4F4E 4F36 4F59 4F5D 4F48 4F5A 514C
514B 514D 5175 51B6 51B7 5225 5224 5229 522A 5228
52AB 52A9 52AA 52AC 5323 5373 5375 541D 542D 541E
543E 5426 544E 5427 5446 5443 5433 5448 5442 541B
5429 544A 5439 543B 5438 542E 5435 5436 5420 543C
5440 5431 542B 541F 542C 56EA 56F0 56E4 56EB 574A
5751 5740 574D 5747 574E 573E 5750 574F 573B 58EF
593E 599D 5992 59A8 599E 59A3 5999 5996 598D 59A4
5993 598A 59A5 5B5D 5B5C 5B5A 5B5B 5B8C 5B8B 5B8F
5C2C 5C40 5C41 5C3F 5C3E 5C90 5C91 5C94 5C8C 5DEB
5E0C 5E8F 5E87 5E8A 5EF7 5F04 5F1F 5F64 5F62 5F77
5F79 5FD8 5FCC 5FD7 5FCD 5FF1 5FEB 5FF8 5FEA 6212
6211 6284 6297 6296 6280 6276 6289 626D 628A 627C
627E 6279 6273 6292 626F 6298 626E 6295 6293 6291
6286 6539 653B 6538 65F1 66F4 675F 674E 674F 6750
6751 675C 6756 675E 6749 6746 6760 6753 6757 6B65
6BCF 6C42 6C5E 6C99 6C81 6C88 6C89 6C85 6C9B 6C6A
6C7A 6C90 6C70 6C8C 6C68 6C96 6C92 6C7D 6C83 6C72
6C7E 6C74 6C86 6C76 6C8D 6C94 6C98 6C82 7076 707C
707D 7078 7262 7261 7260 72C4 72C2 7396 752C 752B
7537 7538 7682 76EF 77E3 79C1 79C0 79BF 7A76 7CFB
7F55 8096 8093 809D 8098 809B 809A 80B2 826F 8292
828B 828D 898B 89D2 8A00 8C37 8C46 8C55 8C9D 8D64
8D70 8DB3 8EAB 8ECA 8F9B 8FB0 8FC2 8FC6 8FC5 8FC4
5DE1 9091 90A2 90AA 90A6 90A3 9149 91C6 91CC 9632
962E 9631 962A 962C 4E26 4E56 4E73 4E8B 4E9B 4E9E
4EAB 4EAC 4F6F 4F9D 4F8D 4F73 4F7F 4F6C 4F9B 4F8B
4F86 4F83 4F70 4F75 4F88 4F69 4F7B 4F96 4F7E 4F8F
4F91 4F7A 5154 5152 5155 5169 5177 5176 5178 51BD
51FD 523B 5238 5237 523A 5230 522E 5236 5241 52BE
52BB 5352 5354 5353 5351 5366 5377 5378 5379 53D6
53D4 53D7 5473 5475 5496 5478 5495 5480 547B 5477
5484 5492 5486 547C 5490 5471 5476 548C 549A 5462
5468 548B 547D 548E 56FA 5783 5777 576A 5769 5761
5766 5764 577C 591C 5949 5947 5948 5944 5954 59BE
59BB 59D4 59B9 59AE 59D1 59C6 59D0 59CD 59CB 59D3
59CA 59AF 59B3 59D2 59C5 5B5F 5B64 5B63 5B97 5B9A
5B98 5B9C 5B99 5B9B 5C1A 5C48 5C45 5C46 5CB7 5CA1
5CB8 5CA9 5CAB 5CB1 5CB3 5E18 5E1A 5E16 5E15 5E1B
5E11 5E78 5E9A 5E97 5E9C 5E95 5E96 5EF6 5F26 5F27
5F29 5F80 5F81 5F7F 5F7C 5FDD 5FE0 5FFD 5FF5 5FFF
600F 6014 602F 6035 6016 602A 6015 6021 6027 6029
602B 601B 6216 6215 623F 623E 6240 627F 62C9 62CC
62C4 62BF 62C2 62B9 62D2 62DB 62AB 62D3 62D4 62CB
62C8 62A8 62BD 62BC 62D0 62D9 62C7 62CD 62B5 62DA
62B1 62D8 62D6 62D7 62C6 62AC 62CE 653E 65A7 65BC
65FA 6614 6613 660C 6606 6602 660E 6600 660F 6615
660A 6607 670D 670B 676D 678B 6795 6771 679C 6773
6777 6787 679D 6797 676F 6770 677F 6789 677E 6790
6775 679A 6793 677C 676A 6772 6B23 6B66 6B67 6B7F
6C13 6C1B 6CE3 6CE8 6CF3 6CB1 6CCC 6CE5 6CB3 6CBD
6CBE 6CBC 6CE2 6CAB 6CD5 6CD3 6CB8 6CC4 6CB9 6CC1
6CAE 6CD7 6CC5 6CF1 6CBF 6CBB 6CE1 6CDB 6CCA 6CAC
6CEF 6CDC 6CD6 6CE0 7095 708E 7092 708A 7099 722C
722D 7238 7248 7267 7269 72C0 72CE 72D9 72D7 72D0
73A9 73A8 739F 73AB 73A5 753D 759D 7599 759A 7684
76C2 76F2 76F4 77E5 77FD 793E 7940 7941 79C9 79C8
7A7A 7A79 7AFA 7CFE 7F54 7F8C 7F8B 8005 80BA 80A5
80A2 80B1 80A1 80AB 80A9 80B4 80AA 80AF 81E5 81FE
820D 82B3 829D 8299 82AD 82BD 829F 82B9 82B1 82AC
82A5 82AF 82B8 82A3 82B0 82BE 82B7 864E 8671 521D
8868 8ECB 8FCE 8FD4 8FD1 90B5 90B8 90B1 90B6 91C7
91D1 9577 9580 961C 9640 963F 963B 9644 9642 96B9
96E8 9752 975E 4E9F 4EAD 4EAE 4FE1 4FB5 4FAF 4FBF
4FE0 4FD1 4FCF 4FDD 4FC3 4FB6 4FD8 4FDF 4FCA 4FD7
4FAE 4FD0 4FC4 4FC2 4FDA 4FCE 4FDE 4FB7 5157 5192
5191 51A0 524E 5243 524A 524D 524C 524B 5247 52C7
52C9 52C3 52C1 530D 5357 537B 539A 53DB 54AC 54C0
54A8 54CE 54C9 54B8 54A6 54B3 54C7 54C2 54BD 54AA
54C1 54C4 54C8 54AF 54AB 54B1 54BB 54A9 54A7 54BF
56FF 5782 578B 57A0 57A3 57A2 57CE 57AE 5793 5955
5951 594F 594E 5950 59DC 59D8 59FF 59E3 59E8 5A03
59E5 59EA 59DA 59E6 5A01 59FB 5B69 5BA3 5BA6 5BA4
5BA2 5BA5 5C01 5C4E 5C4F 5C4D 5C4B 5CD9 5CD2 5DF7
5E1D 5E25 5E1F 5E7D 5EA0 5EA6 5EFA 5F08 5F2D 5F65
5F88 5F85 5F8A 5F8B 5F87 5F8C 5F89 6012 601D 6020
6025 600E 6028 604D 6070 6068 6062 6046 6043 606C
606B 606A 6064 6241 62DC 6316 6309 62FC 62ED 6301
62EE 62FD 6307 62F1 62F7 62EF 62EC 62FE 62F4 6311
6302 653F 6545 65AB 65BD 65E2 6625 662D 6620 6627
662F 661F 6628 6631 6624 66F7 67FF 67D3 67F1 67D4
67D0 67EC 67B6 67AF 67F5 67E9 67EF 67C4 67D1 67B4
67DA 67E5 67B8 67CF 67DE 67F3 67B0 67D9 67E2 67DD
67D2 6B6A 6B83 6B86 6BB5 6BD2 6BD7 6C1F 6CC9 6D0B
6D32 6D2A 6D41 6D25 6D0C 6D31 6D1E 6D17 6D3B 6D3D
6D3E 6D36 6D1B 6CF5 6D39 6D27 6D38 6D29 6D2E 6D35
6D0E 6D2B 70AB 70BA 70B3 70AC 70AF 70AD 70B8 70AE
70A4 7230 7272 726F 7274 72E9 72E0 72E1 73B7 73CA
73BB 73B2 73CD 73C0 73B3 751A 752D 754F 754C 754E
754B 75AB 75A4 75A5 75A2 75A3 7678 7686 7687 7688
76C8 76C6 76C3 76C5 7701 76F9 76F8 7709 770B 76FE
76FC 7707 77DC 7802 7814 780C 780D 7946 7949 7948
7947 79B9 79BA 79D1 79D2 79CB 7A7F 7A81 7AFF 7AFD
7C7D 7D02 7D05 7D00 7D09 7D07 7D04 7D06 7F38 7F8E
7FBF 8004 8010 800D 8011 8036 80D6 80E5 80DA 80C3
80C4 80CC 80E1 80DB 80CE 80DE 80E4 80DD 81F4 8222
82E7 8303 8305 82E3 82DB 82E6 8304 82E5 8302 8309
82D2 82D7 82F1 8301 82DC 82D4 82D1 82DE 82D3 82DF
82EF 8306 8650 8679 867B 867A 884D 886B 8981 89D4
8A08 8A02 8A03 8C9E 8CA0 8D74 8D73 8DB4 8ECD 8ECC
8FF0 8FE6 8FE2 8FEA 8FE5 8FED 8FEB 8FE4 8FE8 90CA
90CE 90C1 90C3 914B 914A 91CD 9582 9650 964B 964C
964D 9762 9769 97CB 97ED 97F3 9801 98A8 98DB 98DF
9996 9999 4E58 4EB3 500C 500D 5023 4FEF 5026 5025
4FF8 5029 5016 5006 503C 501F 501A 5012 5011 4FFA
5000 5014 5028 4FF1 5021 500B 5019 5018 4FF3 4FEE
502D 502A 4FFE 502B 5009 517C 51A4 51A5 51A2 51CD
51CC 51C6 51CB 5256 525C 5254 525B 525D 532A 537F
539F 539D 53DF 54E8 5510 5501 5537 54FC 54E5 54F2
5506 54FA 5514 54E9 54ED 54E1 5509 54EE 54EA 54E6
5527 5507 54FD 550F 5703 5704 57C2 57D4 57CB 57C3
5809 590F 5957 5958 595A 5A11 5A18 5A1C 5A1F 5A1B
5A13 59EC 5A20 5A23 5A29 5A25 5A0C 5A09 5B6B 5C58
5BB0 5BB3 5BB6 5BB4 5BAE 5BB5 5BB9 5BB8 5C04 5C51
5C55 5C50 5CED 5CFD 5CFB 5CEA 5CE8 5CF0 5CF6 5D01
5CF4 5DEE 5E2D 5E2B 5EAB 5EAD 5EA7 5F31 5F92 5F91
5F90 6059 6063 6065 6050 6055 606D 6069 606F 6084
609F 609A 608D 6094 608C 6085 6096 6247 62F3 6308
62FF 634E 633E 632F 6355 6342 6346 634F 6349 633A
6350 633D 632A 632B 6328 634D 634C 6548 6549 6599
65C1 65C5 6642 6649 664F 6643 6652 664C 6645 6641
66F8 6714 6715 6717 6821 6838 6848 6846 6853 6839
6842 6854 6829 68B3 6817 684C 6851 683D 67F4 6850
6840 683C 6843 682A 6845 6813 6818 6841 6B8A 6B89
6BB7 6C23 6C27 6C28 6C26 6C24 6CF0 6D6A 6D95 6D88
6D87 6D66 6D78 6D77 6D59 6D93 6D6C 6D89 6D6E 6D5A
6D74 6D69 6D8C 6D8A 6D79 6D85 6D65 6D94 70CA 70D8
70E4 70D9 70C8 70CF 7239 7279 72FC 72F9 72FD 72F8
72F7 7386 73ED 7409 73EE 73E0 73EA 73DE 7554 755D
755C 755A 7559 75BE 75C5 75C7 75B2 75B3 75BD 75BC
75B9 75C2 75B8 768B 76B0 76CA 76CD 76CE 7729 771F
7720 7728 77E9 7830 7827 7838 781D 7834 7837 7825
782D 7820 781F 7832 7955 7950 7960 795F 7956 795E
795D 7957 795A 79E4 79E3 79E7 79DF 79E6 79E9 79D8
7A84 7A88 7AD9 7B06 7B11 7C89 7D21 7D17 7D0B 7D0A
7D20 7D22 7D14 7D10 7D15 7D1A 7D1C 7D0D 7D19 7D1B
7F3A 7F5F 7F94 7FC5 7FC1 8006 8018 8015 8019 8017
803D 803F 80F1 8102 80F0 8105 80ED 80F4 8106 80F8
80F3 8108 80FD 810A 80FC 80EF 81ED 81EC 8200 8210
822A 822B 8228 822C 82BB 832B 8352 8354 834A 8338
8350 8349 8335 8334 834F 8332 8339 8336 8317 8340
8331 8328 8343 8654 868A 86AA 8693 86A4 86A9 868C
86A3 869C 8870 8877 8881 8882 887D 8879 8A18 8A10
8A0E 8A0C 8A15 8A0A 8A17 8A13 8A16 8A0F 8A11 8C48
8C7A 8C79 8CA1 8CA2 8D77 8EAC 8ED2 8ED4 8ECF 8FB1
9001 9006 8FF7 9000 8FFA 8FF4 9003 8FFD 9005 8FF8
9095 90E1 90DD 90E2 9152 914D 914C 91D8 91DD 91D7
91DC 91D9 9583 9662 9663 9661 965B 965D 9664 9658
965E 96BB 98E2 99AC 9AA8 9AD8 9B25 9B32 9B3C 4E7E
507A 507D 505C 5047 5043 504C 505A 5049 5065 5076
504E 5055 5075 5074 5077 504F 500F 506F 506D 515C
5195 51F0 526A 526F 52D2 52D9 52D8 52D5 5310 530F
5319 533F 5340 533E 53C3 66FC 5546 556A 5566 5544
555E 5561 5543 554A 5531 5556 554F 5555 552F 5564
5538 552E 555C 552C 5563 5533 5541 5557 5708 570B
5709 57DF 5805 580A 5806 57E0 57E4 57FA 5802 5835
57F7 57F9 5920 5962 5A36 5A41 5A49 5A66 5A6A 5A40
5A3C 5A62 5A5A 5A46 5A4A 5B70 5BC7 5BC5 5BC4 5BC2
5BBF 5BC6 5C09 5C08 5C07 5C60 5C5C 5C5D 5D07 5D06
5D0E 5D1B 5D16 5D22 5D11 5D29 5D14 5D19 5D24 5D27
5D17 5DE2 5E38 5E36 5E33 5E37 5EB7 5EB8 5EB6 5EB5
5EBE 5F35 5F37 5F57 5F6C 5F69 5F6B 5F97 5F99 5F9E
5F98 5FA1 5FA0 5F9C 607F 60A3 6089 60A0 60A8 60CB
60B4 60E6 60BD 60C5 60BB 60B5 60DC 60BC 60D8 60D5
60C6 60DF 60B8 60DA 60C7 621A 621B 6248 63A0 63A7
6372 6396 63A2 63A5 6377 6367 6398 63AA 6371 63A9
6389 6383 639B 636B 63A8 6384 6388 6399 63A1 63AC
6392 638F 6380 637B 6369 6368 637A 655D 6556 6551
6559 6557 555F 654F 6558 6555 6554 659C 659B 65AC
65CF 65CB 65CC 65CE 665D 665A 6664 6668 6666 665E
66F9 52D7 671B 6881 68AF 68A2 6893 68B5 687F 6876
68B1 68A7 6897 68B0 6883 68C4 68AD 6886 6885 6894
689D 68A8 689F 68A1 6882 6B32 6BBA 6BEB 6BEC 6C2B
6D8E 6DBC 6DF3 6DD9 6DB2 6DE1 6DCC 6DE4 6DFB 6DFA
6E05 6DC7 6DCB 6DAF 6DD1 6DAE 6DDE 6DF9 6DB8 6DF7
6DF5 6DC5 6DD2 6E1A 6DB5 6DDA 6DEB 6DD8 6DEA 6DF1
6DEE 6DE8 6DC6 6DC4 6DAA 6DEC 6DBF 6DE6 70F9 7109
710A 70FD 70EF 723D 727D 7281 731C 731B 7316 7313
7319 7387 7405 740A 7403 7406 73FE 740D 74E0 74F6
74F7 751C 7522 7565 7566 7562 7570 758F 75D4 75D5
75B5 75CA 75CD 768E 76D4 76D2 76DB 7737 773E 773C
7736 7738 773A 786B 7843 784E 7965 7968 796D 79FB
7A92 7A95 7B20 7B28 7B1B 7B2C 7B26 7B19 7B1E 7B2E
7C92 7C97 7C95 7D46 7D43 7D71 7D2E 7D39 7D3C 7D40
7D30 7D33 7D44 7D2F 7D42 7D32 7D31 7F3D 7F9E 7F9A
7FCC 7FCE 7FD2 801C 804A 8046 812F 8116 8123 812B
8129 8130 8124 8202 8235 8237 8236 8239 838E 839E
8398 8378 83A2 8396 83BD 83AB 8392 838A 8393 8389
83A0 8377 837B 837C 8386 83A7 8655 5F6A 86C7 86C0
86B6 86C4 86B5 86C6 86CB 86B1 86AF 86C9 8853 889E
8888 88AB 8892 8896 888D 888B 8993 898F 8A2A 8A1D
8A23 8A25 8A31 8A2D 8A1F 8A1B 8A22 8C49 8C5A 8CA9
8CAC 8CAB 8CA8 8CAA 8CA7 8D67 8D66 8DBE 8DBA 8EDB
8EDF 9019 900D 901A 9017 9023 901F 901D 9010 9015
901E 9020 900F 9022 9016 901B 9014 90E8 90ED 90FD
9157 91CE 91F5 91E6 91E3 91E7 91ED 91E9 9589 966A
9675 9673 9678 9670 9674 9676 9677 966C 96C0 96EA
96E9 7AE0 7ADF 9802 9803 9B5A 9CE5 9E75 9E7F 9EA5
9EBB 50A2 508D 5085 5099 5091 5080 5096 5098 509A
6700 51F1 5272 5274 5275 5269 52DE 52DD 52DB 535A
53A5 557B 5580 55A7 557C 558A 559D 5598 5582 559C
55AA 5594 5587 558B 5583 55B3 55AE 559F 553E 55B2
559A 55BB 55AC 55B1 557E 5589 55AB 5599 570D 582F
582A 5834 5824 5830 5831 5821 581D 5820 58F9 58FA
5960 5A77 5A9A 5A7F 5A92 5A9B 5AA7 5B73 5B71 5BD2
5BCC 5BD3 5BD0 5C0A 5C0B 5C31 5D4C 5D50 5D34 5D47
5DFD 5E45 5E3D 5E40 5E43 5E7E 5ECA 5EC1 5EC2 5EC4
5F3C 5F6D 5FA9 5FAA 5FA8 60D1 60E1 60B2 60B6 60E0
611C 6123 60FA 6115 60F0 60FB 60F4 6168 60F1 610E
60F6 6109 6100 6112 621F 6249 63A3 638C 63CF 63C0
63E9 63C9 63C6 63CD 63D2 63E3 63D0 63E1 63D6 63ED
63EE 6376 63F4 63EA 63DB 6452 63DA 63F9 655E 6566
6562 6563 6591 6590 65AF 666E 6670 6674 6676 666F
6691 667A 667E 6677 66FE 66FF 671F 671D 68FA 68D5
68E0 68D8 68D7 6905 68DF 68F5 68EE 68E7 68F9 68D2
68F2 68E3 68CB 68CD 690D 6912 690E 68C9 68DA 696E
68FB 6B3E 6B3A 6B3D 6B98 6B96 6BBC 6BEF 6C2E 6C2F
6C2C 6E2F 6E38 6E54 6E21 6E32 6E67 6E4A 6E20 6E25
6E23 6E1B 6E5B 6E58 6E24 6E56 6E6E 6E2D 6E26 6E6F
6E34 6E4D 6E3A 6E2C 6E43 6E1D 6E3E 6ECB 6E89 6E19
6E4E 6E63 6E44 6E72 6E69 6E5F 7119 711A 7126 7130
7121 7136 716E 711C 724C 7284 7280 7336 7325 7334
7329 743A 742A 7433 7422 7425 7435 7436 7434 742F
741B 7426 7428 7525 7526 756B 756A 75E2 75DB 75E3
75D9 75D8 75DE 75E0 767B 767C 7696 7693 76B4 76DC
774F 77ED 785D 786C 786F 7A0D 7A08 7A0B 7A05 7A00
7A98 7A97 7A96 7AE5 7AE3 7B49 7B56 7B46 7B50 7B52
7B54 7B4D 7B4B 7B4F 7B51 7C9F 7CA5 7D5E 7D50 7D68
7D55 7D2B 7D6E 7D72 7D61 7D66 7D62 7D70 7D73 5584
7FD4 7FD5 800B 8052 8085 8155 8154 814B 8151 814E
8139 8146 813E 814C 8153 8174 8212 821C 83E9 8403
83F8 840D 83E0 83C5 840B 83C1 83EF 83F1 83F4 8457
840A 83F0 840C 83CC 83FD 83F2 83CA 8438 840E 8404
83DC 8407 83D4 83DF 865B 86DF 86D9 86ED 86D4 86DB
86E4 86D0 86DE 8857 88C1 88C2 88B1 8983 8996 8A3B
8A60 8A55 8A5E 8A3C 8A41 8A54 8A5B 8A50 8A46 8A34
8A3A 8A36 8A56 8C61 8C82 8CAF 8CBC 8CB3 8CBD 8CC1
8CBB 8CC0 8CB4 8CB7 8CB6 8CBF 8CB8 8D8A 8D85 8D81
8DCE 8DDD 8DCB 8DDA 8DD1 8DCC 8DDB 8DC6 8EFB 8EF8
8EFC 8F9C 902E 9035 9031 9038 9032 9036 9102 90F5
9109 90FE 9163 9165 91CF 9214 9215 9223 9209 921E
920D 9210 9207 9211 9594 958F 958B 9591 9593 9592
958E 968A 968E 968B 967D 9685 9686 968D 9672 9684
96C1 96C5 96C4 96C6 96C7 96EF 96F2 97CC 9805 9806
9808 98E7 98EA 98EF 98E9 98F2 98ED 99AE 99AD 9EC3
9ECD 9ED1 4E82 50AD 50B5 50B2 50B3 50C5 50BE 50AC
50B7 50BB 50AF 50C7 527F 5277 527D 52DF 52E6 52E4
52E2 52E3 532F 55DF 55E8 55D3 55E6 55CE 55DC 55C7
55D1 55E3 55E4 55EF 55DA 55E1 55C5 55C6 55E5 55C9
5712 5713 585E 5851 5858 5857 585A 5854 586B 584C
586D 584A 5862 5852 584B 5967 5AC1 5AC9 5ACC 5ABE
5ABD 5ABC 5AB3 5AC2 5AB2 5D69 5D6F 5E4C 5E79 5EC9
5EC8 5F12 5F59 5FAC 5FAE 611A 610F 6148 611F 60F3
611B 60F9 6101 6108 614E 614C 6144 614D 613E 6134
6127 610D 6106 6137 6221 6222 6413 643E 641E 642A
642D 643D 642C 640F 641C 6414 640D 6436 6416 6417
6406 656C 659F 65B0 6697 6689 6687 6688 6696 6684
6698 668D 6703 6994 696D 695A 6977 6960 6954 6975
6930 6982 694A 6968 696B 695E 6953 6979 6986 695D
6963 695B 6B47 6B72 6BC0 6BBF 6BD3 6BFD 6EA2 6EAF
6ED3 6EB6 6EC2 6E90 6E9D 6EC7 6EC5 6EA5 6E98 6EBC
6EBA 6EAB 6ED1 6E96 6E9C 6EC4 6ED4 6EAA 6EA7 6EB4
714E 7159 7169 7164 7149 7167 715C 716C 7166 714C
7165 715E 7146 7168 7156 723A 7252 7337 7345 733F
733E 746F 745A 7455 745F 745E 7441 743F 7459 745B
745C 7576 7578 7600 75F0 7601 75F2 75F1 75FA 75FF
75F4 75F3 76DE 76DF 775B 776B 7766 775E 7763 7779
776A 776C 775C 7765 7768 7762 77EE 788E 78B0 7897
7898 788C 7889 787C 7891 7893 787F 797A 797F 7981
842C 79BD 7A1C 7A1A 7A20 7A14 7A1F 7A1E 7A9F 7AA0
7B77 7BC0 7B60 7B6E 7B67 7CB1 7CB3 7CB5 7D93 7D79
7D91 7D81 7D8F 7D5B 7F6E 7F69 7F6A 7F72 7FA9 7FA8
7FA4 8056 8058 8086 8084 8171 8170 8178 8165 816E
8173 816B 8179 817A 8166 8205 8247 8482 8477 843D
8431 8475 8466 846B 8449 846C 845B 843C 8435 8461
8463 8469 846D 8446 865E 865C 865F 86F9 8713 8708
8707 8700 86FE 86FB 8702 8703 8706 870A 8859 88DF
88D4 88D9 88DC 88D8 88DD 88E1 88CA 88D5 88D2 899C
89E3 8A6B 8A72 8A73 8A66 8A69 8A70 8A87 8A7C 8A63
8AA0 8A71 8A85 8A6D 8A62 8A6E 8A6C 8A79 8A7B 8A3E
8A68 8C62 8C8A 8C89 8CCA 8CC7 8CC8 8CC4 8CB2 8CC3
8CC2 8CC5 8DE1 8DDF 8DE8 8DEF 8DF3 8DFA 8DEA 8DE4
8DE6 8EB2 8F03 8F09 8EFE 8F0A 8F9F 8FB2 904B 904A
9053 9042 9054 903C 9055 9050 9047 904F 904E 904D
9051 903E 9041 9112 9117 916C 916A 9169 91C9 9237
9257 9238 923D 9240 923E 925B 924B 9264 9251 9234
9249 924D 9245 9239 923F 925A 9598 9698 9694 9695
96CD 96CB 96C9 96CA 96F7 96FB 96F9 96F6 9756 9774
9776 9810 9811 9813 980A 9812 980C 98FC 98F4 98FD
98FE 99B3 99B1 99B4 9AE1 9CE9 9E82 9F0E 9F13 9F20
50E7 50EE 50E5 50D6 50ED 50DA 50D5 50CF 50D1 50F1
50CE 50E9 5162 51F3 5283 5282 5331 53AD 55FE 5600
561B 5617 55FD 5614 5606 5609 560D 560E 55F7 5616
561F 5608 5610 55F6 5718 5716 5875 587E 5883 5893
588A 5879 5885 587D 58FD 5925 5922 5924 596A 5969
5AE1 5AE6 5AE9 5AD7 5AD6 5AD8 5AE3 5B75 5BDE 5BE7
5BE1 5BE5 5BE6 5BE8 5BE2 5BE4 5BDF 5C0D 5C62 5D84
5D87 5E5B 5E63 5E55 5E57 5E54 5ED3 5ED6 5F0A 5F46
5F70 5FB9 6147 613F 614B 6177 6162 6163 615F 615A
6158 6175 622A 6487 6458 6454 64A4 6478 645F 647A
6451 6467 6434 646D 647B 6572 65A1 65D7 65D6 66A2
66A8 669D 699C 69A8 6995 69C1 69AE 69D3 69CB 699B
69B7 69BB 69AB 69B4 69D0 69CD 69AD 69CC 69A6 69C3
69A3 6B49 6B4C 6C33 6F33 6F14 6EFE 6F13 6EF4 6F29
6F3E 6F20 6F2C 6F0F 6F02 6F22 6EFF 6EEF 6F06 6F31
6F38 6F32 6F23 6F15 6F2B 6F2F 6F88 6F2A 6EEC 6F01
6EF2 6ECC 6EF7 7194 7199 717D 718A 7184 7192 723E
7292 7296 7344 7350 7464 7463 746A 7470 746D 7504
7591 7627 760D 760B 7609 7613 76E1 76E3 7784 777D
777F 7761 78C1 789F 78A7 78B3 78A9 78A3 798E 798F
798D 7A2E 7A31 7AAA 7AA9 7AED 7AEF 7BA1 7B95 7B8B
7B75 7B97 7B9D 7B94 7B8F 7BB8 7B87 7B84 7CB9 7CBD
7CBE 7DBB 7DB0 7D9C 7DBD 7DBE 7DA0 7DCA 7DB4 7DB2
7DB1 7DBA 7DA2 7DBF 7DB5 7DB8 7DAD 7DD2 7DC7 7DAC
7F70 7FE0 7FE1 7FDF 805E 805A 8087 8150 8180 818F
8188 818A 817F 8182 81E7 81FA 8207 8214 821E 824B
84C9 84BF 84C6 84C4 8499 849E 84B2 849C 84CB 84B8
84C0 84D3 8490 84BC 84D1 84CA 873F 871C 873B 8722
8725 8734 8718 8755 8737 8729 88F3 8902 88F4 88F9
88F8 88FD 88E8 891A 88EF 8AA6 8A8C 8A9E 8AA3 8A8D
8AA1 8A93 8AA4 8AAA 8AA5 8AA8 8A98 8A91 8A9A 8AA7
8C6A 8C8D 8C8C 8CD3 8CD1 8CD2 8D6B 8D99 8D95 8DFC
8F14 8F12 8F15 8F13 8FA3 9060 9058 905C 9063 9059
905E 9062 905D 905B 9119 9118 911E 9175 9178 9177
9174 9278 9280 9285 9298 9296 927B 9293 929C 92A8
927C 9291 95A1 95A8 95A9 95A3 95A5 95A4 9699 969C
969B 96CC 96D2 9700 977C 9785 97F6 9817 9818 98AF
98B1 9903 9905 990C 9909 99C1 9AAF 9AB0 9AE6 9B41
9B42 9CF4 9CF6 9CF3 9EBC 9F3B 9F4A 5104 5100 50FB
50F5 50F9 5102 5108 5109 5105 51DC 5287 5288 5289
528D 528A 52F0 53B2 562E 563B 5639 5632 563F 5634
5629 5653 564E 5657 5674 5636 562F 5630 5880 589F
589E 58B3 589C 58AE 58A9 58A6 596D 5B09 5AFB 5B0B
5AF5 5B0C 5B08 5BEE 5BEC 5BE9 5BEB 5C64 5C65 5D9D
5D94 5E62 5E5F 5E61 5EE2 5EDA 5EDF 5EDD 5EE3 5EE0
5F48 5F71 5FB7 5FB5 6176 6167 616E 615D 6155 6182
617C 6170 616B 617E 61A7 6190 61AB 618E 61AC 619A
61A4 6194 61AE 622E 6469 646F 6479 649E 64B2 6488
6490 64B0 64A5 6493 6495 64A9 6492 64AE 64AD 64AB
649A 64AC 6499 64A2 64B3 6575 6577 6578 66AE 66AB
66B4 66B1 6A23 6A1F 69E8 6A01 6A1E 6A19 69FD 6A21
6A13 6A0A 69F3 6A02 6A05 69ED 6A11 6B50 6B4E 6BA4
6BC5 6BC6 6F3F 6F7C 6F84 6F51 6F66 6F54 6F86 6F6D
6F5B 6F78 6F6E 6F8E 6F7A 6F70 6F64 6F97 6F58 6ED5
6F6F 6F60 6F5F 719F 71AC 71B1 71A8 7256 729B 734E
7357 7469 748B 7483 747E 7480 757F 7620 7629 761F
7624 7626 7621 7622 769A 76BA 76E4 778E 7787 778C
7791 778B 78CB 78C5 78BA 78CA 78BE 78D5 78BC 78D0
7A3F 7A3C 7A40 7A3D 7A37 7A3B 7AAF 7AAE 7BAD 7BB1
7BC4 7BB4 7BC6 7BC7 7BC1 7BA0 7BCC 7CCA 7DE0 7DF4
7DEF 7DFB 7DD8 7DEC 7DDD 7DE8 7DE3 7DDA 7DDE 7DE9
7D9E 7DD9 7DF2 7DF9 7F75 7F77 7FAF 7FE9 8026 819B
819C 819D 81A0 819A 8198 8517 853D 851A 84EE 852C
852D 8513 8511 8523 8521 8514 84EC 8525 84FF 8506
8782 8774 8776 8760 8766 8778 8768 8759 8757 874C
8753 885B 885D 8910 8907 8912 8913 8915 890A 8ABC
8AD2 8AC7 8AC4 8A95 8ACB 8AF8 8AB2 8AC9 8AC2 8ABF
8AB0 8AD6 8ACD 8AB6 8AB9 8ADB 8C4C 8C4E 8C6C 8CE0
8CDE 8CE6 8CE4 8CEC 8CED 8CE2 8CE3 8CDC 8CEA 8CE1
8D6D 8D9F 8DA3 8E2B 8E10 8E1D 8E22 8E0F 8E29 8E1F
8E21 8E1E 8EBA 8F1D 8F1B 8F1F 8F29 8F26 8F2A 8F1C
8F1E 8F25 9069 906E 9068 906D 9077 9130 912D 9127
9131 9187 9189 918B 9183 92C5 92BB 92B7 92EA 92AC
92E4 92C1 92B3 92BC 92D2 92C7 92F0 92B2 95AD 95B1
9704 9706 9707 9709 9760 978D 978B 978F 9821 982B
981C 98B3 990A 9913 9912 9918 99DD 99D0 99DF 99DB
99D1 99D5 99D2 99D9 9AB7 9AEE 9AEF 9B27 9B45 9B44
9B77 9B6F 9D06 9D09 9D03 9EA9 9EBE 9ECE 58A8 9F52
5112 5118 5114 5110 5115 5180 51AA 51DD 5291 5293
52F3 5659 566B 5679 5669 5664 5678 566A 5668 5665
5671 566F 566C 5662 5676 58C1 58BE 58C7 58C5 596E
5B1D 5B34 5B78 5BF0 5C0E 5F4A 61B2 6191 61A9 618A
61CD 61B6 61BE 61CA 61C8 6230 64C5 64C1 64CB 64BB
64BC 64DA 64C4 64C7 64C2 64CD 64BF 64D2 64D4 64BE
6574 66C6 66C9 66B9 66C4 66C7 66B8 6A3D 6A38 6A3A
6A59 6A6B 6A58 6A39 6A44 6A62 6A61 6A4B 6A47 6A35
6A5F 6A48 6B59 6B77 6C05 6FC2 6FB1 6FA1 6FC3 6FA4
6FC1 6FA7 6FB3 6FC0 6FB9 6FB6 6FA6 6FA0 6FB4 71BE
71C9 71D0 71D2 71C8 71D5 71B9 71CE 71D9 71DC 71C3
71C4 7368 749C 74A3 7498 749F 749E 74E2 750C 750D
7634 7638 763A 76E7 76E5 77A0 779E 779F 77A5 78E8
78DA 78EC 78E7 79A6 7A4D 7A4E 7A46 7A4C 7A4B 7ABA
7BD9 7C11 7BC9 7BE4 7BDB 7BE1 7BE9 7BE6 7CD5 7CD6
7E0A 7E11 7E08 7E1B 7E23 7E1E 7E1D 7E09 7E10 7F79
7FB2 7FF0 7FF1 7FEE 8028 81B3 81A9 81A8 81FB 8208
8258 8259 854A 8559 8548 8568 8569 8543 8549 856D
856A 855E 8783 879F 879E 87A2 878D 8861 892A 8932
8925 892B 8921 89AA 89A6 8AE6 8AFA 8AEB 8AF1 8B00
8ADC 8AE7 8AEE 8AFE 8B01 8B02 8AF7 8AED 8AF3 8AF6
8AFC 8C6B 8C6D 8C93 8CF4 8E44 8E31 8E34 8E42 8E39
8E35 8F3B 8F2F 8F38 8F33 8FA8 8FA6 9075 9074 9078
9072 907C 907A 9134 9192 9320 9336 92F8 9333 932F
9322 92FC 932B 9304 931A 9310 9326 9321 9315 932E
9319 95BB 96A7 96A8 96AA 96D5 970E 9711 9716 970D
9713 970F 975B 975C 9766 9798 9830 9838 983B 9837
982D 9839 9824 9910 9928 991E 991B 9921 991A 99ED
99E2 99F1 9AB8 9ABC 9AFB 9AED 9B28 9B91 9D15 9D23
9D26 9D28 9D12 9D1B 9ED8 9ED4 9F8D 9F9C 512A 511F
5121 5132 52F5 568E 5680 5690 5685 5687 568F 58D5
58D3 58D1 58CE 5B30 5B2A 5B24 5B7A 5C37 5C68 5DBC
5DBA 5DBD 5DB8 5E6B 5F4C 5FBD 61C9 61C2 61C7 61E6
61CB 6232 6234 64CE 64CA 64D8 64E0 64F0 64E6 64EC
64F1 64E2 64ED 6582 6583 66D9 66D6 6A80 6A94 6A84
6AA2 6A9C 6ADB 6AA3 6A7E 6A97 6A90 6AA0 6B5C 6BAE
6BDA 6C08 6FD8 6FF1 6FDF 6FE0 6FDB 6FE4 6FEB 6FEF
6F80 6FEC 6FE1 6FE9 6FD5 6FEE 6FF0 71E7 71DF 71EE
71E6 71E5 71ED 71EC 71F4 71E0 7235 7246 7370 7372
74A9 74B0 74A6 74A8 7646 7642 764C 76EA 77B3 77AA
77B0 77AC 77A7 77AD 77EF 78F7 78FA 78F4 78EF 7901
79A7 79AA 7A57 7ABF 7C07 7C0D 7BFE 7BF7 7C0C 7BE0
7CE0 7CDC 7CDE 7CE2 7CDF 7CD9 7CDD 7E2E 7E3E 7E46
7E37 7E32 7E43 7E2B 7E3D 7E31 7E45 7E41 7E34 7E39
7E48 7E35 7E3F 7E2F 7F44 7FF3 7FFC 8071 8072 8070
806F 8073 81C6 81C3 81BA 81C2 81C0 81BF 81BD 81C9
81BE 81E8 8209 8271 85AA 8584 857E 859C 8591 8594
85AF 859B 8587 85A8 858A 8667 87C0 87D1 87B3 87D2
87C6 87AB 87BB 87BA 87C8 87CB 893B 8936 8944 8938
893D 89AC 8B0E 8B17 8B19 8B1B 8B0A 8B20 8B1D 8B04
8B10 8C41 8C3F 8C73 8CFA 8CFD 8CFC 8CF8 8CFB 8DA8
8E49 8E4B 8E48 8E4A 8F44 8F3E 8F42 8F45 8F3F 907F
907D 9084 9081 9082 9080 9139 91A3 919E 919C 934D
9382 9328 9375 934A 9365 934B 9318 937E 936C 935B
9370 935A 9354 95CA 95CB 95CC 95C8 95C6 96B1 96B8
96D6 971C 971E 97A0 97D3 9846 98B6 9935 9A01 99FF
9BAE 9BAB 9BAA 9BAD 9D3B 9D3F 9E8B 9ECF 9EDE 9EDC
9EDD 9EDB 9F3E 9F4B 53E2 5695 56AE 58D9 58D8 5B38
5F5D 61E3 6233 64F4 64F2 64FE 6506 64FA 64FB 64F7
65B7 66DC 6726 6AB3 6AAC 6AC3 6ABB 6AB8 6AC2 6AAE
6AAF 6B5F 6B78 6BAF 7009 700B 6FFE 7006 6FFA 7011
700F 71FB 71FC 71FE 71F8 7377 7375 74A7 74BF 7515
7656 7658 7652 77BD 77BF 77BB 77BC 790E 79AE 7A61
7A62 7A60 7AC4 7AC5 7C2B 7C27 7C2A 7C1E 7C23 7C21
7CE7 7E54 7E55 7E5E 7E5A 7E61 7E52 7E59 7F48 7FF9
7FFB 8077 8076 81CD 81CF 820A 85CF 85A9 85CD 85D0
85C9 85B0 85BA 85B9 85A6 87EF 87EC 87F2 87E0 8986
89B2 89F4 8B28 8B39 8B2C 8B2B 8C50 8D05 8E59 8E63
8E66 8E64 8E5F 8E55 8EC0 8F49 8F4D 9087 9083 9088
91AB 91AC 91D0 9394 938A 9396 93A2 93B3 93AE 93AC
93B0 9398 939A 9397 95D4 95D6 95D0 95D5 96E2 96DC
96D9 96DB 96DE 9724 97A3 97A6 97AD 97F9 984D 984F
984C 984E 9853 98BA 993E 993F 993D 992E 99A5 9A0E
9AC1 9B03 9B06 9B4F 9B4E 9B4D 9BCA 9BC9 9BFD 9BC8
9BC0 9D51 9D5D 9D60 9EE0 9F15 9F2C 5133 56A5 58DE
58DF 58E2 5BF5 9F90 5EEC 61F2 61F7 61F6 61F5 6500
650F 66E0 66DD 6AE5 6ADD 6ADA 6AD3 701B 701F 7028
701A 701D 7015 7018 7206 720D 7258 72A2 7378 737A
74BD 74CA 74E3 7587 7586 765F 7661 77C7 7919 79B1
7A6B 7A69 7C3E 7C3F 7C38 7C3D 7C37 7C40 7E6B 7E6D
7E79 7E69 7E6A 7F85 7E73 7FB6 7FB9 7FB8 81D8 85E9
85DD 85EA 85D5 85E4 85E5 85F7 87FB 8805 880D 87F9
87FE 8960 895F 8956 895E 8B41 8B5C 8B58 8B49 8B5A
8B4E 8B4F 8B46 8B59 8D08 8D0A 8E7C 8E72 8E87 8E76
8E6C 8E7A 8E74 8F54 8F4E 8FAD 908A 908B 91B1 91AE
93E1 93D1 93DF 93C3 93C8 93DC 93DD 93D6 93E2 93CD
93D8 93E4 93D7 93E8 95DC 96B4 96E3 972A 9727 9761
97DC 97FB 985E 9858 985B 98BC 9945 9949 9A16 9A19
9B0D 9BE8 9BE7 9BD6 9BDB 9D89 9D61 9D72 9D6A 9D6C
9E92 9E97 9E93 9EB4 52F8 56A8 56B7 56B6 56B4 56BC
58E4 5B40 5B43 5B7D 5BF6 5DC9 61F8 61FA 6518 6514
6519 66E6 6727 6AEC 703E 7030 7032 7210 737B 74CF
7662 7665 7926 792A 792C 792B 7AC7 7AF6 7C4C 7C43
7C4D 7CEF 7CF0 8FAE 7E7D 7E7C 7E82 7F4C 8000 81DA
8266 85FB 85F9 8611 85FA 8606 860B 8607 860A 8814
8815 8964 89BA 89F8 8B70 8B6C 8B66 8B6F 8B5F 8B6B
8D0F 8D0D 8E89 8E81 8E85 8E82 91B4 91CB 9418 9403
93FD 95E1 9730 98C4 9952 9951 99A8 9A2B 9A30 9A37
9A35 9C13 9C0D 9E79 9EB5 9EE8 9F2F 9F5F 9F63 9F61
5137 5138 56C1 56C0 56C2 5914 5C6C 5DCD 61FC 61FE
651D 651C 6595 66E9 6AFB 6B04 6AFA 6BB2 704C 721B
72A7 74D6 74D4 7669 77D3 7C50 7E8F 7E8C 7FBC 8617
862D 861A 8823 8822 8821 881F 896A 896C 89BD 8B74
8B77 8B7D 8D13 8E8A 8E8D 8E8B 8F5F 8FAF 91BA 942E
9433 9435 943A 9438 9432 942B 95E2 9738 9739 9732
97FF 9867 9865 9957 9A45 9A43 9A40 9A3E 9ACF 9B54
9B51 9C2D 9C25 9DAF 9DB4 9DC2 9DB8 9E9D 9EEF 9F19
9F5C 9F66 9F67 513C 513B 56C8 56CA 56C9 5B7F 5DD4
5DD2 5F4E 61FF 6524 6B0A 6B61 7051 7058 7380 74E4
758A 766E 766C 79B3 7C60 7C5F 807E 807D 81DF 8972
896F 89FC 8B80 8D16 8D17 8E91 8E93 8F61 9148 9444
9451 9452 973D 973E 97C3 97C1 986B 9955 9A55 9A4D
9AD2 9B1A 9C49 9C31 9C3E 9C3B 9DD3 9DD7 9F34 9F6C
9F6A 9F94 56CC 5DD6 6200 6523 652B 652A 66EC 6B10
74DA 7ACA 7C64 7C63 7C65 7E93 7E96 7E94 81E2 8638
863F 8831 8B8A 9090 908F 9463 9460 9464 9768 986F
995C 9A5A 9A5B 9A57 9AD3 9AD4 9AD1 9C54 9C57 9C56
9DE5 9E9F 9EF4 56D1 58E9 652C 705E 7671 7672 77D7
7F50 7F88 8836 8839 8862 8B93 8B92 8B96 8277 8D1B
91C0 946A 9742 9748 9744 97C6 9870 9A5F 9B22 9B58
9C5F 9DF9 9DFA 9E7C 9E7D 9F07 9F77 9F72 5EF3 6B16
7063 7C6C 7C6E 883B 89C0 8EA1 91C1 9472 9470 9871
995E 9AD6 9B23 9ECC 7064 77DA 8B9A 9477 97C9 9A62
9A65 7E9C 8B9C 8EAA 91C5 947D 947E 947C 9C77 9C78
9EF7 8C54 947F 9E1A 7228 9A6A 9B31 9E1B 9E1E 7C72
4E42 4E5C 51F5 531A 5382 4E07 4E0C 4E47 4E8D 56D7
5C6E 5F73 4E0F 5187 4E0E 4E2E 4E93 4EC2 4EC9 4EC8
5198 52FC 536C 53B9 5720 5903 592C 5C10 5DFF 65E1
6BB3 6BCC 6C14 723F 4E31 4E3C 4EE8 4EDC 4EE9 4EE1
4EDD 4EDA 520C 531C 534C 5722 5723 5917 592F 5B81
5B84 5C12 5C3B 5C74 5C73 5E04 5E80 5E82 5FC9 6209
6250 6C15 6C36 6C43 6C3F 6C3B 72AE 72B0 738A 79B8
808A 961E 4F0E 4F18 4F2C 4EF5 4F14 4EF1 4F00 4EF7
4F08 4F1D 4F02 4F05 4F22 4F13 4F04 4EF4 4F12 51B1
5213 5209 5210 52A6 5322 531F 534D 538A 5407 56E1
56DF 572E 572A 5734 593C 5980 597C 5985 597B 597E
5977 597F 5B56 5C15 5C25 5C7C 5C7A 5C7B 5C7E 5DDF
5E75 5E84 5F02 5F1A 5F74 5FD5 5FD4 5FCF 625C 625E
6264 6261 6266 6262 6259 6260 625A 6265 65EF 65EE
673E 6739 6738 673B 673A 673F 673C 6733 6C18 6C46
6C52 6C5C 6C4F 6C4A 6C54 6C4B 6C4C 7071 725E 72B4
72B5 738E 752A 767F 7A75 7F51 8278 827C 8280 827D
827F 864D 897E 9099 9097 9098 909B 9094 9622 9624
9620 9623 4F56 4F3B 4F62 4F49 4F53 4F64 4F3E 4F67
4F52 4F5F 4F41 4F58 4F2D 4F33 4F3F 4F61 518F 51B9
521C 521E 5221 52AD 52AE 5309 5363 5372 538E 538F
5430 5437 542A 5454 5445 5419 541C 5425 5418 543D
544F 5441 5428 5424 5447 56EE 56E7 56E5 5741 5745
574C 5749 574B 5752 5906 5940 59A6 5998 59A0 5997
598E 59A2 5990 598F 59A7 59A1 5B8E 5B92 5C28 5C2A
5C8D 5C8F 5C88 5C8B 5C89 5C92 5C8A 5C86 5C93 5C95
5DE0 5E0A 5E0E 5E8B 5E89 5E8C 5E88 5E8D 5F05 5F1D
5F78 5F76 5FD2 5FD1 5FD0 5FED 5FE8 5FEE 5FF3 5FE1
5FE4 5FE3 5FFA 5FEF 5FF7 5FFB 6000 5FF4 623A 6283
628C 628E 628F 6294 6287 6271 627B 627A 6270 6281
6288 6277 627D 6272 6274 6537 65F0 65F4 65F3 65F2
65F5 6745 6747 6759 6755 674C 6748 675D 674D 675A
674B 6BD0 6C19 6C1A 6C78 6C67 6C6B 6C84 6C8B 6C8F
6C71 6C6F 6C69 6C9A 6C6D 6C87 6C95 6C9C 6C66 6C73
6C65 6C7B 6C8E 7074 707A 7263 72BF 72BD 72C3 72C6
72C1 72BA 72C5 7395 7397 7393 7394 7392 753A 7539
7594 7595 7681 793D 8034 8095 8099 8090 8092 809C
8290 828F 8285 828E 8291 8293 828A 8283 8284 8C78
8FC9 8FBF 909F 90A1 90A5 909E 90A7 90A0 9630 9628
962F 962D 4E33 4F98 4F7C 4F85 4F7D 4F80 4F87 4F76
4F74 4F89 4F84 4F77 4F4C 4F97 4F6A 4F9A 4F79 4F81
4F78 4F90 4F9C 4F94 4F9E 4F92 4F82 4F95 4F6B 4F6E
519E 51BC 51BE 5235 5232 5233 5246 5231 52BC 530A
530B 533C 5392 5394 5487 547F 5481 5491 5482 5488
546B 547A 547E 5465 546C 5474 5466 548D 546F 5461
5460 5498 5463 5467 5464 56F7 56F9 576F 5772 576D
576B 5771 5770 5776 5780 5775 577B 5773 5774 5762
5768 577D 590C 5945 59B5 59BA 59CF 59CE 59B2 59CC
59C1 59B6 59BC 59C3 59D6 59B1 59BD 59C0 59C8 59B4
59C7 5B62 5B65 5B93 5B95 5C44 5C47 5CAE 5CA4 5CA0
5CB5 5CAF 5CA8 5CAC 5C9F 5CA3 5CAD 5CA2 5CAA 5CA7
5C9D 5CA5 5CB6 5CB0 5CA6 5E17 5E14 5E19 5F28 5F22
5F23 5F24 5F54 5F82 5F7E 5F7D 5FDE 5FE5 602D 6026
6019 6032 600B 6034 600A 6017 6033 601A 601E 602C
6022 600D 6010 602E 6013 6011 600C 6009 601C 6214
623D 62AD 62B4 62D1 62BE 62AA 62B6 62CA 62AE 62B3
62AF 62BB 62A9 62B0 62B8 653D 65A8 65BB 6609 65FC
6604 6612 6608 65FB 6603 660B 660D 6605 65FD 6611
6610 66F6 670A 6785 676C 678E 6792 6776 677B 6798
6786 6784 6774 678D 678C 677A 679F 6791 6799 6783
677D 6781 6778 6779 6794 6B25 6B80 6B7E 6BDE 6C1D
6C93 6CEC 6CEB 6CEE 6CD9 6CB6 6CD4 6CAD 6CE7 6CB7
6CD0 6CC2 6CBA 6CC3 6CC6 6CED 6CF2 6CD2 6CDD 6CB4
6C8A 6C9D 6C80 6CDE 6CC0 6D30 6CCD 6CC7 6CB0 6CF9
6CCF 6CE9 6CD1 7094 7098 7085 7093 7086 7084 7091
7096 7082 709A 7083 726A 72D6 72CB 72D8 72C9 72DC
72D2 72D4 72DA 72CC 72D1 73A4 73A1 73AD 73A6 73A2
73A0 73AC 739D 74DD 74E8 753F 7540 753E 758C 7598
76AF 76F3 76F1 76F0 76F5 77F8 77FC 77F9 77FB 77FA
77F7 7942 793F 79C5 7A78 7A7B 7AFB 7C75 7CFD 8035
808F 80AE 80A3 80B8 80B5 80AD 8220 82A0 82C0 82AB
829A 8298 829B 82B5 82A7 82AE 82BC 829E 82BA 82B4
82A8 82A1 82A9 82C2 82A4 82C3 82B6 82A2 8670 866F
866D 866E 8C56 8FD2 8FCB 8FD3 8FCD 8FD6 8FD5 8FD7
90B2 90B4 90AF 90B3 90B0 9639 963D 963C 963A 9643
4FCD 4FC5 4FD3 4FB2 4FC9 4FCB 4FC1 4FD4 4FDC 4FD9
4FBB 4FB3 4FDB 4FC7 4FD6 4FBA 4FC0 4FB9 4FEC 5244
5249 52C0 52C2 533D 537C 5397 5396 5399 5398 54BA
54A1 54AD 54A5 54CF 54C3 830D 54B7 54AE 54D6 54B6
54C5 54C6 54A0 5470 54BC 54A2 54BE 5472 54DE 54B0
57B5 579E 579F 57A4 578C 5797 579D 579B 5794 5798
578F 5799 57A5 579A 5795 58F4 590D 5953 59E1 59DE
59EE 5A00 59F1 59DD 59FA 59FD 59FC 59F6 59E4 59F2
59F7 59DB 59E9 59F3 59F5 59E0 59FE 59F4 59ED 5BA8
5C4C 5CD0 5CD8 5CCC 5CD7 5CCB 5CDB 5CDE 5CDA 5CC9
5CC7 5CCA 5CD6 5CD3 5CD4 5CCF 5CC8 5CC6 5CCE 5CDF
5CF8 5DF9 5E21 5E22 5E23 5E20 5E24 5EB0 5EA4 5EA2
5E9B 5EA3 5EA5 5F07 5F2E 5F56 5F86 6037 6039 6054
6072 605E 6045 6053 6047 6049 605B 604C 6040 6042
605F 6024 6044 6058 6066 606E 6242 6243 62CF 630D
630B 62F5 630E 6303 62EB 62F9 630F 630C 62F8 62F6
6300 6313 6314 62FA 6315 62FB 62F0 6541 6543 65AA
65BF 6636 6621 6632 6635 661C 6626 6622 6633 662B
663A 661D 6634 6639 662E 670F 6710 67C1 67F2 67C8
67BA 67DC 67BB 67F8 67D8 67C0 67B7 67C5 67EB 67E4
67DF 67B5 67CD 67B3 67F7 67F6 67EE 67E3 67C2 67B9
67CE 67E7 67F0 67B2 67FC 67C6 67ED 67CC 67AE 67E6
67DB 67FA 67C9 67CA 67C3 67EA 67CB 6B28 6B82 6B84
6BB6 6BD6 6BD8 6BE0 6C20 6C21 6D28 6D34 6D2D 6D1F
6D3C 6D3F 6D12 6D0A 6CDA 6D33 6D04 6D19 6D3A 6D1A
6D11 6D00 6D1D 6D42 6D01 6D18 6D37 6D03 6D0F 6D40
6D07 6D20 6D2C 6D08 6D22 6D09 6D10 70B7 709F 70BE
70B1 70B0 70A1 70B4 70B5 70A9 7241 7249 724A 726C
7270 7273 726E 72CA 72E4 72E8 72EB 72DF 72EA 72E6
72E3 7385 73CC 73C2 73C8 73C5 73B9 73B6 73B5 73B4
73EB 73BF 73C7 73BE 73C3 73C6 73B8 73CB 74EC 74EE
752E 7547 7548 75A7 75AA 7679 76C4 7708 7703 7704
7705 770A 76F7 76FB 76FA 77E7 77E8 7806 7811 7812
7805 7810 780F 780E 7809 7803 7813 794A 794C 794B
7945 7944 79D5 79CD 79CF 79D6 79CE 7A80 7A7E 7AD1
7B00 7B01 7C7A 7C78 7C79 7C7F 7C80 7C81 7D03 7D08
7D01 7F58 7F91 7F8D 7FBE 8007 800E 800F 8014 8037
80D8 80C7 80E0 80D1 80C8 80C2 80D0 80C5 80E3 80D9
80DC 80CA 80D5 80C9 80CF 80D7 80E6 80CD 81FF 8221
8294 82D9 82FE 82F9 8307 82E8 8300 82D5 833A 82EB
82D6 82F4 82EC 82E1 82F2 82F5 830C 82FB 82F6 82F0
82EA 82E4 82E0 82FA 82F3 82ED 8677 8674 867C 8673
8841 884E 8867 886A 8869 89D3 8A04 8A07 8D72 8FE3
8FE1 8FEE 8FE0 90F1 90BD 90BF 90D5 90C5 90BE 90C7
90CB 90C8 91D4 91D3 9654 964F 9651 9653 964A 964E
501E 5005 5007 5013 5022 5030 501B 4FF5 4FF4 5033
5037 502C 4FF6 4FF7 5017 501C 5020 5027 5035 502F
5031 500E 515A 5194 5193 51CA 51C4 51C5 51C8 51CE
5261 525A 5252 525E 525F 5255 5262 52CD 530E 539E
5526 54E2 5517 5512 54E7 54F3 54E4 551A 54FF 5504
5508 54EB 5511 5505 54F1 550A 54FB 54F7 54F8 54E0
550E 5503 550B 5701 5702 57CC 5832 57D5 57D2 57BA
57C6 57BD 57BC 57B8 57B6 57BF 57C7 57D0 57B9 57C1
590E 594A 5A19 5A16 5A2D 5A2E 5A15 5A0F 5A17 5A0A
5A1E 5A33 5B6C 5BA7 5BAD 5BAC 5C03 5C56 5C54 5CEC
5CFF 5CEE 5CF1 5CF7 5D00 5CF9 5E29 5E28 5EA8 5EAE
5EAA 5EAC 5F33 5F30 5F67 605D 605A 6067 6041 60A2
6088 6080 6092 6081 609D 6083 6095 609B 6097 6087
609C 608E 6219 6246 62F2 6310 6356 632C 6344 6345
6336 6343 63E4 6339 634B 634A 633C 6329 6341 6334
6358 6354 6359 632D 6347 6333 635A 6351 6338 6357
6340 6348 654A 6546 65C6 65C3 65C4 65C2 664A 665F
6647 6651 6712 6713 681F 681A 6849 6832 6833 683B
684B 684F 6816 6831 681C 6835 682B 682D 682F 684E
6844 6834 681D 6812 6814 6826 6828 682E 684D 683A
6825 6820 6B2C 6B2F 6B2D 6B31 6B34 6B6D 8082 6B88
6BE6 6BE4 6BE8 6BE3 6BE2 6BE7 6C25 6D7A 6D63 6D64
6D76 6D0D 6D61 6D92 6D58 6D62 6D6D 6D6F 6D91 6D8D
6DEF 6D7F 6D86 6D5E 6D67 6D60 6D97 6D70 6D7C 6D5F
6D82 6D98 6D2F 6D68 6D8B 6D7E 6D80 6D84 6D16 6D83
6D7B 6D7D 6D75 6D90 70DC 70D3 70D1 70DD 70CB 7F39
70E2 70D7 70D2 70DE 70E0 70D4 70CD 70C5 70C6 70C7
70DA 70CE 70E1 7242 7278 7277 7276 7300 72FA 72F4
72FE 72F6 72F3 72FB 7301 73D3 73D9 73E5 73D6 73BC
73E7 73E3 73E9 73DC 73D2 73DB 73D4 73DD 73DA 73D7
73D8 73E8 74DE 74DF 74F4 74F5 7521 755B 755F 75B0
75C1 75BB 75C4 75C0 75BF 75B6 75BA 768A 76C9 771D
771B 7710 7713 7712 7723 7711 7715 7719 771A 7722
7727 7823 782C 7822 7835 782F 7828 782E 782B 7821
7829 7833 782A 7831 7954 795B 794F 795C 7953 7952
7951 79EB 79EC 79E0 79EE 79ED 79EA 79DC 79DE 79DD
7A86 7A89 7A85 7A8B 7A8C 7A8A 7A87 7AD8 7B10 7B04
7B13 7B05 7B0F 7B08 7B0A 7B0E 7B09 7B12 7C84 7C91
7C8A 7C8C 7C88 7C8D 7C85 7D1E 7D1D 7D11 7D0E 7D18
7D16 7D13 7D1F 7D12 7D0F 7D0C 7F5C 7F61 7F5E 7F60
7F5D 7F5B 7F96 7F92 7FC3 7FC2 7FC0 8016 803E 8039
80FA 80F2 80F9 80F5 8101 80FB 8100 8201 822F 8225
8333 832D 8344 8319 8351 8325 8356 833F 8341 8326
831C 8322 8342 834E 831B 832A 8308 833C 834D 8316
8324 8320 8337 832F 8329 8347 8345 834C 8353 831E
832C 834B 8327 8348 8653 8652 86A2 86A8 8696 868D
8691 869E 8687 8697 8686 868B 869A 8685 86A5 8699
86A1 86A7 8695 8698 868E 869D 8690 8694 8843 8844
886D 8875 8876 8872 8880 8871 887F 886F 8883 887E
8874 887C 8A12 8C47 8C57 8C7B 8CA4 8CA3 8D76 8D78
8DB5 8DB7 8DB6 8ED1 8ED3 8FFE 8FF5 9002 8FFF 8FFB
9004 8FFC 8FF6 90D6 90E0 90D9 90DA 90E3 90DF 90E5
90D8 90DB 90D7 90DC 90E4 9150 914E 914F 91D5 91E2
91DA 965C 965F 96BC 98E3 9ADF 9B2F 4E7F 5070 506A
5061 505E 5060 5053 504B 505D 5072 5048 504D 5041
505B 504A 5062 5015 5045 505F 5069 506B 5063 5064
5046 5040 506E 5073 5057 5051 51D0 526B 526D 526C
526E 52D6 52D3 532D 539C 5575 5576 553C 554D 5550
5534 552A 5551 5562 5536 5535 5530 5552 5545 550C
5532 5565 554E 5539 5548 552D 553B 5540 554B 570A
5707 57FB 5814 57E2 57F6 57DC 57F4 5800 57ED 57FD
5808 57F8 580B 57F3 57CF 5807 57EE 57E3 57F2 57E5
57EC 57E1 580E 57FC 5810 57E7 5801 580C 57F1 57E9
57F0 580D 5804 595C 5A60 5A58 5A55 5A67 5A5E 5A38
5A35 5A6D 5A50 5A5F 5A65 5A6C 5A53 5A64 5A57 5A43
5A5D 5A52 5A44 5A5B 5A48 5A8E 5A3E 5A4D 5A39 5A4C
5A70 5A69 5A47 5A51 5A56 5A42 5A5C 5B72 5B6E 5BC1
5BC0 5C59 5D1E 5D0B 5D1D 5D1A 5D20 5D0C 5D28 5D0D
5D26 5D25 5D0F 5D30 5D12 5D23 5D1F 5D2E 5E3E 5E34
5EB1 5EB4 5EB9 5EB2 5EB3 5F36 5F38 5F9B 5F96 5F9F
608A 6090 6086 60BE 60B0 60BA 60D3 60D4 60CF 60E4
60D9 60DD 60C8 60B1 60DB 60B7 60CA 60BF 60C3 60CD
60C0 6332 6365 638A 6382 637D 63BD 639E 63AD 639D
6397 63AB 638E 636F 6387 6390 636E 63AF 6375 639C
636D 63AE 637C 63A4 633B 639F 6378 6385 6381 6391
638D 6370 6553 65CD 6665 6661 665B 6659 665C 6662
6718 6879 6887 6890 689C 686D 686E 68AE 68AB 6956
686F 68A3 68AC 68A9 6875 6874 68B2 688F 6877 6892
687C 686B 6872 68AA 6880 6871 687E 689B 6896 688B
68A0 6889 68A4 6878 687B 6891 688C 688A 687D 6B36
6B33 6B37 6B38 6B91 6B8F 6B8D 6B8E 6B8C 6C2A 6DC0
6DAB 6DB4 6DB3 6E74 6DAC 6DE9 6DE2 6DB7 6DF6 6DD4
6E00 6DC8 6DE0 6DDF 6DD6 6DBE 6DE5 6DDC 6DDD 6DDB
6DF4 6DCA 6DBD 6DED 6DF0 6DBA 6DD5 6DC2 6DCF 6DC9
6DD0 6DF2 6DD3 6DFD 6DD7 6DCD 6DE3 6DBB 70FA 710D
70F7 7117 70F4 710C 70F0 7104 70F3 7110 70FC 70FF
7106 7113 7100 70F8 70F6 710B 7102 710E 727E 727B
727C 727F 731D 7317 7307 7311 7318 730A 7308 72FF
730F 731E 7388 73F6 73F8 73F5 7404 7401 73FD 7407
7400 73FA 73FC 73FF 740C 740B 73F4 7408 7564 7563
75CE 75D2 75CF 75CB 75CC 75D1 75D0 768F 7689 76D3
7739 772F 772D 7731 7732 7734 7733 773D 7725 773B
7735 7848 7852 7849 784D 784A 784C 7826 7845 7850
7964 7967 7969 796A 7963 796B 7961 79BB 79FA 79F8
79F6 79F7 7A8F 7A94 7A90 7B35 7B47 7B34 7B25 7B30
7B22 7B24 7B33 7B18 7B2A 7B1D 7B31 7B2B 7B2D 7B2F
7B32 7B38 7B1A 7B23 7C94 7C98 7C96 7CA3 7D35 7D3D
7D38 7D36 7D3A 7D45 7D2C 7D29 7D41 7D47 7D3E 7D3F
7D4A 7D3B 7D28 7F63 7F95 7F9C 7F9D 7F9B 7FCA 7FCB
7FCD 7FD0 7FD1 7FC7 7FCF 7FC9 801F 801E 801B 8047
8043 8048 8118 8125 8119 811B 812D 811F 812C 811E
8121 8115 8127 811D 8122 8211 8238 8233 823A 8234
8232 8274 8390 83A3 83A8 838D 837A 8373 83A4 8374
838F 8381 8395 8399 8375 8394 83A9 837D 8383 838C
839D 839B 83AA 838B 837E 83A5 83AF 8388 8397 83B0
837F 83A6 8387 83AE 8376 839A 8659 8656 86BF 86B7
86C2 86C1 86C5 86BA 86B0 86C8 86B9 86B3 86B8 86CC
86B4 86BB 86BC 86C3 86BD 86BE 8852 8889 8895 88A8
88A2 88AA 889A 8891 88A1 889F 8898 88A7 8899 889B
8897 88A4 88AC 888C 8893 888E 8982 89D6 89D9 89D5
8A30 8A27 8A2C 8A1E 8C39 8C3B 8C5C 8C5D 8C7D 8CA5
8D7D 8D7B 8D79 8DBC 8DC2 8DB9 8DBF 8DC1 8ED8 8EDE
8EDD 8EDC 8ED7 8EE0 8EE1 9024 900B 9011 901C 900C
9021 90EF 90EA 90F0 90F4 90F2 90F3 90D4 90EB 90EC
90E9 9156 9158 915A 9153 9155 91EC 91F4 91F1 91F3
91F8 91E4 91F9 91EA 91EB 91F7 91E8 91EE 957A 9586
9588 967C 966D 966B 9671 966F 96BF 976A 9804 98E5
9997 509B 5095 5094 509E 508B 50A3 5083 508C 508E
509D 5068 509C 5092 5082 5087 515F 51D4 5312 5311
53A4 53A7 5591 55A8 55A5 55AD 5577 5645 55A2 5593
5588 558F 55B5 5581 55A3 5592 55A4 557D 558C 55A6
557F 5595 55A1 558E 570C 5829 5837 5819 581E 5827
5823 5828 57F5 5848 5825 581C 581B 5833 583F 5836
582E 5839 5838 582D 582C 583B 5961 5AAF 5A94 5A9F
5A7A 5AA2 5A9E 5A78 5AA6 5A7C 5AA5 5AAC 5A95 5AAE
5A37 5A84 5A8A 5A97 5A83 5A8B 5AA9 5A7B 5A7D 5A8C
5A9C 5A8F 5A93 5A9D 5BEA 5BCD 5BCB 5BD4 5BD1 5BCA
5BCE 5C0C 5C30 5D37 5D43 5D6B 5D41 5D4B 5D3F 5D35
5D51 5D4E 5D55 5D33 5D3A 5D52 5D3D 5D31 5D59 5D42
5D39 5D49 5D38 5D3C 5D32 5D36 5D40 5D45 5E44 5E41
5F58 5FA6 5FA5 5FAB 60C9 60B9 60CC 60E2 60CE 60C4
6114 60F2 610A 6116 6105 60F5 6113 60F8 60FC 60FE
60C1 6103 6118 611D 6110 60FF 6104 610B 624A 6394
63B1 63B0 63CE 63E5 63E8 63EF 63C3 649D 63F3 63CA
63E0 63F6 63D5 63F2 63F5 6461 63DF 63BE 63DD 63DC
63C4 63D8 63D3 63C2 63C7 63CC 63CB 63C8 63F0 63D7
63D9 6532 6567 656A 6564 655C 6568 6565 658C 659D
659E 65AE 65D0 65D2 667C 666C 667B 6680 6671 6679
666A 6672 6701 690C 68D3 6904 68DC 692A 68EC 68EA
68F1 690F 68D6 68F7 68EB 68E4 68F6 6913 6910 68F3
68E1 6907 68CC 6908 6970 68B4 6911 68EF 68C6 6914
68F8 68D0 68FD 68FC 68E8 690B 690A 6917 68CE 68C8
68DD 68DE 68E6 68F4 68D1 6906 68D4 68E9 6915 6925
68C7 6B39 6B3B 6B3F 6B3C 6B94 6B97 6B99 6B95 6BBD
6BF0 6BF2 6BF3 6C30 6DFC 6E46 6E47 6E1F 6E49 6E88
6E3C 6E3D 6E45 6E62 6E2B 6E3F 6E41 6E5D 6E73 6E1C
6E33 6E4B 6E40 6E51 6E3B 6E03 6E2E 6E5E 6E68 6E5C
6E61 6E31 6E28 6E60 6E71 6E6B 6E39 6E22 6E30 6E53
6E65 6E27 6E78 6E64 6E77 6E55 6E79 6E52 6E66 6E35
6E36 6E5A 7120 711E 712F 70FB 712E 7131 7123 7125
7122 7132 711F 7128 713A 711B 724B 725A 7288 7289
7286 7285 728B 7312 730B 7330 7322 7331 7333 7327
7332 732D 7326 7323 7335 730C 742E 742C 7430 742B
7416 741A 7421 742D 7431 7424 7423 741D 7429 7420
7432 74FB 752F 756F 756C 75E7 75DA 75E1 75E6 75DD
75DF 75E4 75D7 7695 7692 76DA 7746 7747 7744 774D
7745 774A 774E 774B 774C 77DE 77EC 7860 7864 7865
785C 786D 7871 786A 786E 7870 7869 7868 785E 7862
7974 7973 7972 7970 7A02 7A0A 7A03 7A0C 7A04 7A99
7AE6 7AE4 7B4A 7B3B 7B44 7B48 7B4C 7B4E 7B40 7B58
7B45 7CA2 7C9E 7CA8 7CA1 7D58 7D6F 7D63 7D53 7D56
7D67 7D6A 7D4F 7D6D 7D5C 7D6B 7D52 7D54 7D69 7D51
7D5F 7D4E 7F3E 7F3F 7F65 7F66 7FA2 7FA0 7FA1 7FD7
8051 804F 8050 80FE 80D4 8143 814A 8152 814F 8147
813D 814D 813A 81E6 81EE 81F7 81F8 81F9 8204 823C
823D 823F 8275 833B 83CF 83F9 8423 83C0 83E8 8412
83E7 83E4 83FC 83F6 8410 83C6 83C8 83EB 83E3 83BF
8401 83DD 83E5 83D8 83FF 83E1 83CB 83CE 83D6 83F5
83C9 8409 840F 83DE 8411 8406 83C2 83F3 83D5 83FA
83C7 83D1 83EA 8413 83C3 83EC 83EE 83C4 83FB 83D7
83E2 841B 83DB 83FE 86D8 86E2 86E6 86D3 86E3 86DA
86EA 86DD 86EB 86DC 86EC 86E9 86D7 86E8 86D1 8848
8856 8855 88BA 88D7 88B9 88B8 88C0 88BE 88B6 88BC
88B7 88BD 88B2 8901 88C9 8995 8998 8997 89DD 89DA
89DB 8A4E 8A4D 8A39 8A59 8A40 8A57 8A58 8A44 8A45
8A52 8A48 8A51 8A4A 8A4C 8A4F 8C5F 8C81 8C80 8CBA
8CBE 8CB0 8CB9 8CB5 8D84 8D80 8D89 8DD8 8DD3 8DCD
8DC7 8DD6 8DDC 8DCF 8DD5 8DD9 8DC8 8DD7 8DC5 8EEF
8EF7 8EFA 8EF9 8EE6 8EEE 8EE5 8EF5 8EE7 8EE8 8EF6
8EEB 8EF1 8EEC 8EF4 8EE9 902D 9034 902F 9106 912C
9104 90FF 90FC 9108 90F9 90FB 9101 9100 9107 9105
9103 9161 9164 915F 9162 9160 9201 920A 9225 9203
921A 9226 920F 920C 9200 9212 91FF 91FD 9206 9204
9227 9202 921C 9224 9219 9217 9205 9216 957B 958D
958C 9590 9687 967E 9688 9689 9683 9680 96C2 96C8
96C3 96F1 96F0 976C 9770 976E 9807 98A9 98EB 9CE6
9EF9 4E83 4E84 4EB6 50BD 50BF 50C6 50AE 50C4 50CA
50B4 50C8 50C2 50B0 50C1 50BA 50B1 50CB 50C9 50B6
50B8 51D7 527A 5278 527B 527C 55C3 55DB 55CC 55D0
55CB 55CA 55DD 55C0 55D4 55C4 55E9 55BF 55D2 558D
55CF 55D5 55E2 55D6 55C8 55F2 55CD 55D9 55C2 5714
5853 5868 5864 584F 584D 5849 586F 5855 584E 585D
5859 5865 585B 583D 5863 5871 58FC 5AC7 5AC4 5ACB
5ABA 5AB8 5AB1 5AB5 5AB0 5ABF 5AC8 5ABB 5AC6 5AB7
5AC0 5ACA 5AB4 5AB6 5ACD 5AB9 5A90 5BD6 5BD8 5BD9
5C1F 5C33 5D71 5D63 5D4A 5D65 5D72 5D6C 5D5E 5D68
5D67 5D62 5DF0 5E4F 5E4E 5E4A 5E4D 5E4B 5EC5 5ECC
5EC6 5ECB 5EC7 5F40 5FAF 5FAD 60F7 6149 614A 612B
6145 6136 6132 612E 6146 612F 614F 6129 6140 6220
9168 6223 6225 6224 63C5 63F1 63EB 6410 6412 6409
6420 6424 6433 6443 641F 6415 6418 6439 6437 6422
6423 640C 6426 6430 6428 6441 6435 642F 640A 641A
6440 6425 6427 640B 63E7 641B 642E 6421 640E 656F
6592 65D3 6686 668C 6695 6690 668B 668A 6699 6694
6678 6720 6966 695F 6938 694E 6962 6971 693F 6945
696A 6939 6942 6957 6959 697A 6948 6949 6935 696C
6933 693D 6965 68F0 6978 6934 6969 6940 696F 6944
6976 6958 6941 6974 694C 693B 694B 6937 695C 694F
6951 6932 6952 692F 697B 693C 6B46 6B45 6B43 6B42
6B48 6B41 6B9B 6BFB 6BFC 6BF9 6BF7 6BF8 6E9B 6ED6
6EC8 6E8F 6EC0 6E9F 6E93 6E94 6EA0 6EB1 6EB9 6EC6
6ED2 6EBD 6EC1 6E9E 6EC9 6EB7 6EB0 6ECD 6EA6 6ECF
6EB2 6EBE 6EC3 6EDC 6ED8 6E99 6E92 6E8E 6E8D 6EA4
6EA1 6EBF 6EB3 6ED0 6ECA 6E97 6EAE 6EA3 7147 7154
7152 7163 7160 7141 715D 7162 7172 7178 716A 7161
7142 7158 7143 714B 7170 715F 7150 7153 7144 714D
715A 724F 728D 728C 7291 7290 728E 733C 7342 733B
733A 7340 734A 7349 7444 744A 744B 7452 7451 7457
7440 744F 7450 744E 7442 7446 744D 7454 74E1 74FF
74FE 74FD 751D 7579 7577 6983 75EF 760F 7603 75F7
75FE 75FC 75F9 75F8 7610 75FB 75F6 75ED 75F5 75FD
7699 76B5 76DD 7755 775F 7760 7752 7756 775A 7769
7767 7754 7759 776D 77E0 7887 789A 7894 788F 7884
7895 7885 7886 78A1 7883 7879 7899 7880 7896 787B
797C 7982 797D 7979 7A11 7A18 7A19 7A12 7A17 7A15
7A22 7A13 7A1B 7A10 7AA3 7AA2 7A9E 7AEB 7B66 7B64
7B6D 7B74 7B69 7B72 7B65 7B73 7B71 7B70 7B61 7B78
7B76 7B63 7CB2 7CB4 7CAF 7D88 7D86 7D80 7D8D 7D7F
7D85 7D7A 7D8E 7D7B 7D83 7D7C 7D8C 7D94 7D84 7D7D
7D92 7F6D 7F6B 7F67 7F68 7F6C 7FA6 7FA5 7FA7 7FDB
7FDC 8021 8164 8160 8177 815C 8169 815B 8162 8172
6721 815E 8176 8167 816F 8144 8161 821D 8249 8244
8240 8242 8245 84F1 843F 8456 8476 8479 848F 848D
8465 8451 8440 8486 8467 8430 844D 847D 845A 8459
8474 8473 845D 8507 845E 8437 843A 8434 847A 8443
8478 8432 8445 8429 83D9 844B 842F 8442 842D 845F
8470 8439 844E 844C 8452 846F 84C5 848E 843B 8447
8436 8433 8468 847E 8444 842B 8460 8454 846E 8450
870B 8704 86F7 870C 86FA 86D6 86F5 874D 86F8 870E
8709 8701 86F6 870D 8705 88D6 88CB 88CD 88CE 88DE
88DB 88DA 88CC 88D0 8985 899B 89DF 89E5 89E4 89E1
89E0 89E2 89DC 89E6 8A76 8A86 8A7F 8A61 8A3F 8A77
8A82 8A84 8A75 8A83 8A81 8A74 8A7A 8C3C 8C4B 8C4A
8C65 8C64 8C66 8C86 8C84 8C85 8CCC 8D68 8D69 8D91
8D8C 8D8E 8D8F 8D8D 8D93 8D94 8D90 8D92 8DF0 8DE0
8DEC 8DF1 8DEE 8DD0 8DE9 8DE3 8DE2 8DE7 8DF2 8DEB
8DF4 8F06 8EFF 8F01 8F00 8F05 8F07 8F08 8F02 8F0B
9052 903F 9044 9049 903D 9110 910D 910F 9111 9116
9114 910B 910E 916E 916F 9248 9252 9230 923A 9266
9233 9265 925E 9283 922E 924A 9246 926D 926C 924F
9260 9267 926F 9236 9261 9270 9231 9254 9263 9250
9272 924E 9253 924C 9256 9232 959F 959C 959E 959B
9692 9693 9691 9697 96CE 96FA 96FD 96F8 96F5 9773
9777 9778 9772 980F 980D 980E 98AC 98F6 98F9 99AF
99B2 99B0 99B5 9AAD 9AAB 9B5B 9CEA 9CED 9CE7 9E80
9EFD 50E6 50D4 50D7 50E8 50F3 50DB 50EA 50DD 50E4
50D3 50EC 50F0 50EF 50E3 50E0 51D8 5280 5281 52E9
52EB 5330 53AC 5627 5615 560C 5612 55FC 560F 561C
5601 5613 5602 55FA 561D 5604 55FF 55F9 5889 587C
5890 5898 5886 5881 587F 5874 588B 587A 5887 5891
588E 5876 5882 5888 587B 5894 588F 58FE 596B 5ADC
5AEE 5AE5 5AD5 5AEA 5ADA 5AED 5AEB 5AF3 5AE2 5AE0
5ADB 5AEC 5ADE 5ADD 5AD9 5AE8 5ADF 5B77 5BE0 5BE3
5C63 5D82 5D80 5D7D 5D86 5D7A 5D81 5D77 5D8A 5D89
5D88 5D7E 5D7C 5D8D 5D79 5D7F 5E58 5E59 5E53 5ED8
5ED1 5ED7 5ECE 5EDC 5ED5 5ED9 5ED2 5ED4 5F44 5F43
5F6F 5FB6 612C 6128 6141 615E 6171 6173 6152 6153
6172 616C 6180 6174 6154 617A 615B 6165 613B 616A
6161 6156 6229 6227 622B 642B 644D 645B 645D 6474
6476 6472 6473 647D 6475 6466 64A6 644E 6482 645E
645C 644B 6453 6460 6450 647F 643F 646C 646B 6459
6465 6477 6573 65A0 66A1 66A0 669F 6705 6704 6722
69B1 69B6 69C9 69A0 69CE 6996 69B0 69AC 69BC 6991
6999 698E 69A7 698D 69A9 69BE 69AF 69BF 69C4 69BD
69A4 69D4 69B9 69CA 699A 69CF 69B3 6993 69AA 69A1
699E 69D9 6997 6990 69C2 69B5 69A5 69C6 6B4A 6B4D
6B4B 6B9E 6B9F 6BA0 6BC3 6BC4 6BFE 6ECE 6EF5 6EF1
6F03 6F25 6EF8 6F37 6EFB 6F2E 6F09 6F4E 6F19 6F1A
6F27 6F18 6F3B 6F12 6EED 6F0A 6F36 6F73 6EF9 6EEE
6F2D 6F40 6F30 6F3C 6F35 6EEB 6F07 6F0E 6F43 6F05
6EFD 6EF6 6F39 6F1C 6EFC 6F3A 6F1F 6F0D 6F1E 6F08
6F21 7187 7190 7189 7180 7185 7182 718F 717B 7186
7181 7197 7244 7253 7297 7295 7293 7343 734D 7351
734C 7462 7473 7471 7475 7472 7467 746E 7500 7502
7503 757D 7590 7616 7608 760C 7615 7611 760A 7614
76B8 7781 777C 7785 7782 776E 7780 776F 777E 7783
78B2 78AA 78B4 78AD 78A8 787E 78AB 789E 78A5 78A0
78AC 78A2 78A4 7998 798A 798B 7996 7995 7994 7993
7997 7988 7992 7990 7A2B 7A4A 7A30 7A2F 7A28 7A26
7AA8 7AAB 7AAC 7AEE 7B88 7B9C 7B8A 7B91 7B90 7B96
7B8D 7B8C 7B9B 7B8E 7B85 7B98 5284 7B99 7BA4 7B82
7CBB 7CBF 7CBC 7CBA 7DA7 7DB7 7DC2 7DA3 7DAA 7DC1
7DC0 7DC5 7D9D 7DCE 7DC4 7DC6 7DCB 7DCC 7DAF 7DB9
7D96 7DBC 7D9F 7DA6 7DAE 7DA9 7DA1 7DC9 7F73 7FE2
7FE3 7FE5 7FDE 8024 805D 805C 8189 8186 8183 8187
818D 818C 818B 8215 8497 84A4 84A1 849F 84BA 84CE
84C2 84AC 84AE 84AB 84B9 84B4 84C1 84CD 84AA 849A
84B1 84D0 849D 84A7 84BB 84A2 8494 84C7 84CC 849B
84A9 84AF 84A8 84D6 8498 84B6 84CF 84A0 84D7 84D4
84D2 84DB 84B0 8491 8661 8733 8723 8728 876B 8740
872E 871E 8721 8719 871B 8743 872C 8741 873E 8746
8720 8732 872A 872D 873C 8712 873A 8731 8735 8742
8726 8727 8738 8724 871A 8730 8711 88F7 88E7 88F1
88F2 88FA 88FE 88EE 88FC 88F6 88FB 88F0 88EC 88EB
899D 89A1 899F 899E 89E9 89EB 89E8 8AAB 8A99 8A8B
8A92 8A8F 8A96 8C3D 8C68 8C69 8CD5 8CCF 8CD7 8D96
8E09 8E02 8DFF 8E0D 8DFD 8E0A 8E03 8E07 8E06 8E05
8DFE 8E00 8E04 8F10 8F11 8F0E 8F0D 9123 911C 9120
9122 911F 911D 911A 9124 9121 911B 917A 9172 9179
9173 92A5 92A4 9276 929B 927A 92A0 9294 92AA 928D
92A6 929A 92AB 9279 9297 927F 92A3 92EE 928E 9282
9295 92A2 927D 9288 92A1 928A 9286 928C 9299 92A7
927E 9287 92A9 929D 928B 922D 969E 96A1 96FF 9758
977D 977A 977E 9783 9780 9782 977B 9784 9781 977F
97CE 97CD 9816 98AD 98AE 9902 9900 9907 999D 999C
99C3 99B9 99BB 99BA 99C2 99BD 99C7 9AB1 9AE3 9AE7
9B3E 9B3F 9B60 9B61 9B5F 9CF1 9CF2 9CF5 9EA7 50FF
5103 5130 50F8 5106 5107 50F6 50FE 510B 510C 50FD
510A 528B 528C 52F1 52EF 5648 5642 564C 5635 5641
564A 5649 5646 5658 565A 5640 5633 563D 562C 563E
5638 562A 563A 571A 58AB 589D 58B1 58A0 58A3 58AF
58AC 58A5 58A1 58FF 5AFF 5AF4 5AFD 5AF7 5AF6 5B03
5AF8 5B02 5AF9 5B01 5B07 5B05 5B0F 5C67 5D99 5D97
5D9F 5D92 5DA2 5D93 5D95 5DA0 5D9C 5DA1 5D9A 5D9E
5E69 5E5D 5E60 5E5C 7DF3 5EDB 5EDE 5EE1 5F49 5FB2
618B 6183 6179 61B1 61B0 61A2 6189 619B 6193 61AF
61AD 619F 6192 61AA 61A1 618D 6166 61B3 622D 646E
6470 6496 64A0 6485 6497 649C 648F 648B 648A 648C
64A3 649F 6468 64B1 6498 6576 657A 6579 657B 65B2
65B3 66B5 66B0 66A9 66B2 66B7 66AA 66AF 6A00 6A06
6A17 69E5 69F8 6A15 69F1 69E4 6A20 69FF 69EC 69E2
6A1B 6A1D 69FE 6A27 69F2 69EE 6A14 69F7 69E7 6A40
6A08 69E6 69FB 6A0D 69FC 69EB 6A09 6A04 6A18 6A25
6A0F 69F6 6A26 6A07 69F4 6A16 6B51 6BA5 6BA3 6BA2
6BA6 6C01 6C00 6BFF 6C02 6F41 6F26 6F7E 6F87 6FC6
6F92 6F8D 6F89 6F8C 6F62 6F4F 6F85 6F5A 6F96 6F76
6F6C 6F82 6F55 6F72 6F52 6F50 6F57 6F94 6F93 6F5D
6F00 6F61 6F6B 6F7D 6F67 6F90 6F53 6F8B 6F69 6F7F
6F95 6F63 6F77 6F6A 6F7B 71B2 71AF 719B 71B0 71A0
719A 71A9 71B5 719D 71A5 719E 71A4 71A1 71AA 719C
71A7 71B3 7298 729A 7358 7352 735E 735F 7360 735D
735B 7361 735A 7359 7362 7487 7489 748A 7486 7481
747D 7485 7488 747C 7479 7508 7507 757E 7625 761E
7619 761D 761C 7623 761A 7628 761B 769C 769D 769E
769B 778D 778F 7789 7788 78CD 78BB 78CF 78CC 78D1
78CE 78D4 78C8 78C3 78C4 78C9 799A 79A1 79A0 799C
79A2 799B 6B76 7A39 7AB2 7AB4 7AB3 7BB7 7BCB 7BBE
7BAC 7BCE 7BAF 7BB9 7BCA 7BB5 7CC5 7CC8 7CCC 7CCB
7DF7 7DDB 7DEA 7DE7 7DD7 7DE1 7E03 7DFA 7DE6 7DF6
7DF1 7DF0 7DEE 7DDF 7F76 7FAC 7FB0 7FAD 7FED 7FEB
7FEA 7FEC 7FE6 7FE8 8064 8067 81A3 819F 819E 8195
81A2 8199 8197 8216 824F 8253 8252 8250 824E 8251
8524 853B 850F 8500 8529 850E 8509 850D 851F 850A
8527 851C 84FB 852B 84FA 8508 850C 84F4 852A 84F2
8515 84F7 84EB 84F3 84FC 8512 84EA 84E9 8516 84FE
8528 851D 852E 8502 84FD 851E 84F6 8531 8526 84E7
84E8 84F0 84EF 84F9 8518 8520 8530 850B 8519 852F
8662 8756 8763 8764 8777 87E1 8773 8758 8754 875B
8752 8761 875A 8751 875E 876D 876A 8750 874E 875F
875D 876F 876C 877A 876E 875C 8765 874F 877B 8775
8762 8767 8769 885A 8905 890C 8914 890B 8917 8918
8919 8906 8916 8911 890E 8909 89A2 89A4 89A3 89ED
89F0 89EC 8ACF 8AC6 8AB8 8AD3 8AD1 8AD4 8AD5 8ABB
8AD7 8ABE 8AC0 8AC5 8AD8 8AC3 8ABA 8ABD 8AD9 8C3E
8C4D 8C8F 8CE5 8CDF 8CD9 8CE8 8CDA 8CDD 8CE7 8DA0
8D9C 8DA1 8D9B 8E20 8E23 8E25 8E24 8E2E 8E15 8E1B
8E16 8E11 8E19 8E26 8E27 8E14 8E12 8E18 8E13 8E1C
8E17 8E1A 8F2C 8F24 8F18 8F1A 8F20 8F23 8F16 8F17
9073 9070 906F 9067 906B 912F 912B 9129 912A 9132
9126 912E 9185 9186 918A 9181 9182 9184 9180 92D0
92C3 92C4 92C0 92D9 92B6 92CF 92F1 92DF 92D8 92E9
92D7 92DD 92CC 92EF 92C2 92E8 92CA 92C8 92CE 92E6
92CD 92D5 92C9 92E0 92DE 92E7 92D1 92D3 92B5 92E1
92C6 92B4 957C 95AC 95AB 95AE 95B0 96A4 96A2 96D3
9705 9708 9702 975A 978A 978E 9788 97D0 97CF 981E
981D 9826 9829 9828 9820 981B 9827 98B2 9908 98FA
9911 9914 9916 9917 9915 99DC 99CD 99CF 99D3 99D4
99CE 99C9 99D6 99D8 99CB 99D7 99CC 9AB3 9AEC 9AEB
9AF3 9AF2 9AF1 9B46 9B43 9B67 9B74 9B71 9B66 9B76
9B75 9B70 9B68 9B64 9B6C 9CFC 9CFA 9CFD 9CFF 9CF7
9D07 9D00 9CF9 9CFB 9D08 9D05 9D04 9E83 9ED3 9F0F
9F10 511C 5113 5117 511A 5111 51DE 5334 53E1 5670
5660 566E 5673 5666 5663 566D 5672 565E 5677 571C
571B 58C8 58BD 58C9 58BF 58BA 58C2 58BC 58C6 5B17
5B19 5B1B 5B21 5B14 5B13 5B10 5B16 5B28 5B1A 5B20
5B1E 5BEF 5DAC 5DB1 5DA9 5DA7 5DB5 5DB0 5DAE 5DAA
5DA8 5DB2 5DAD 5DAF 5DB4 5E67 5E68 5E66 5E6F 5EE9
5EE7 5EE6 5EE8 5EE5 5F4B 5FBC 619D 61A8 6196 61C5
61B4 61C6 61C1 61CC 61BA 61BF 61B8 618C 64D7 64D6
64D0 64CF 64C9 64BD 6489 64C3 64DB 64F3 64D9 6533
657F 657C 65A2 66C8 66BE 66C0 66CA 66CB 66CF 66BD
66BB 66BA 66CC 6723 6A34 6A66 6A49 6A67 6A32 6A68
6A3E 6A5D 6A6D 6A76 6A5B 6A51 6A28 6A5A 6A3B 6A3F
6A41 6A6A 6A64 6A50 6A4F 6A54 6A6F 6A69 6A60 6A3C
6A5E 6A56 6A55 6A4D 6A4E 6A46 6B55 6B54 6B56 6BA7
6BAA 6BAB 6BC8 6BC7 6C04 6C03 6C06 6FAD 6FCB 6FA3
6FC7 6FBC 6FCE 6FC8 6F5E 6FC4 6FBD 6F9E 6FCA 6FA8
7004 6FA5 6FAE 6FBA 6FAC 6FAA 6FCF 6FBF 6FB8 6FA2
6FC9 6FAB 6FCD 6FAF 6FB2 6FB0 71C5 71C2 71BF 71B8
71D6 71C0 71C1 71CB 71D4 71CA 71C7 71CF 71BD 71D8
71BC 71C6 71DA 71DB 729D 729E 7369 7366 7367 736C
7365 736B 736A 747F 749A 74A0 7494 7492 7495 74A1
750B 7580 762F 762D 7631 763D 7633 763C 7635 7632
7630 76BB 76E6 779A 779D 77A1 779C 779B 77A2 77A3
7795 7799 7797 78DD 78E9 78E5 78EA 78DE 78E3 78DB
78E1 78E2 78ED 78DF 78E0 79A4 7A44 7A48 7A47 7AB6
7AB8 7AB5 7AB1 7AB7 7BDE 7BE3 7BE7 7BDD 7BD5 7BE5
7BDA 7BE8 7BF9 7BD4 7BEA 7BE2 7BDC 7BEB 7BD8 7BDF
7CD2 7CD4 7CD7 7CD0 7CD1 7E12 7E21 7E17 7E0C 7E1F
7E20 7E13 7E0E 7E1C 7E15 7E1A 7E22 7E0B 7E0F 7E16
7E0D 7E14 7E25 7E24 7F43 7F7B 7F7C 7F7A 7FB1 7FEF
802A 8029 806C 81B1 81A6 81AE 81B9 81B5 81AB 81B0
81AC 81B4 81B2 81B7 81A7 81F2 8255 8256 8257 8556
8545 856B 854D 8553 8561 8558 8540 8546 8564 8541
8562 8544 8551 8547 8563 853E 855B 8571 854E 856E
8575 8555 8567 8560 858C 8566 855D 8554 8565 856C
8663 8665 8664 879B 878F 8797 8793 8792 8788 8781
8796 8798 8779 8787 87A3 8785 8790 8791 879D 8784
8794 879C 879A 8789 891E 8926 8930 892D 892E 8927
8931 8922 8929 8923 892F 892C 891F 89F1 8AE0 8AE2
8AF2 8AF4 8AF5 8ADD 8B14 8AE4 8ADF 8AF0 8AC8 8ADE
8AE1 8AE8 8AFF 8AEF 8AFB 8C91 8C92 8C90 8CF5 8CEE
8CF1 8CF0 8CF3 8D6C 8D6E 8DA5 8DA7 8E33 8E3E 8E38
8E40 8E45 8E36 8E3C 8E3D 8E41 8E30 8E3F 8EBD 8F36
8F2E 8F35 8F32 8F39 8F37 8F34 9076 9079 907B 9086
90FA 9133 9135 9136 9193 9190 9191 918D 918F 9327
931E 9308 931F 9306 930F 937A 9338 933C 931B 9323
9312 9301 9346 932D 930E 930D 92CB 931D 92FA 9325
9313 92F9 92F7 9334 9302 9324 92FF 9329 9339 9335
932A 9314 930C 930B 92FE 9309 9300 92FB 9316 95BC
95CD 95BE 95B9 95BA 95B6 95BF 95B5 95BD 96A9 96D4
970B 9712 9710 9799 9797 9794 97F0 97F8 9835 982F
9832 9924 991F 9927 9929 999E 99EE 99EC 99E5 99E4
99F0 99E3 99EA 99E9 99E7 9AB9 9ABF 9AB4 9ABB 9AF6
9AFA 9AF9 9AF7 9B33 9B80 9B85 9B87 9B7C 9B7E 9B7B
9B82 9B93 9B92 9B90 9B7A 9B95 9B7D 9B88 9D25 9D17
9D20 9D1E 9D14 9D29 9D1D 9D18 9D22 9D10 9D19 9D1F
9E88 9E86 9E87 9EAE 9EAD 9ED5 9ED6 9EFA 9F12 9F3D
5126 5125 5122 5124 5120 5129 52F4 5693 568C 568D
5686 5684 5683 567E 5682 567F 5681 58D6 58D4 58CF
58D2 5B2D 5B25 5B32 5B23 5B2C 5B27 5B26 5B2F 5B2E
5B7B 5BF1 5BF2 5DB7 5E6C 5E6A 5FBE 5FBB 61C3 61B5
61BC 61E7 61E0 61E5 61E4 61E8 61DE 64EF 64E9 64E3
64EB 64E4 64E8 6581 6580 65B6 65DA 66D2 6A8D 6A96
6A81 6AA5 6A89 6A9F 6A9B 6AA1 6A9E 6A87 6A93 6A8E
6A95 6A83 6AA8 6AA4 6A91 6A7F 6AA6 6A9A 6A85 6A8C
6A92 6B5B 6BAD 6C09 6FCC 6FA9 6FF4 6FD4 6FE3 6FDC
6FED 6FE7 6FE6 6FDE 6FF2 6FDD 6FE2 6FE8 71E1 71F1
71E8 71F2 71E4 71F0 71E2 7373 736E 736F 7497 74B2
74AB 7490 74AA 74AD 74B1 74A5 74AF 7510 7511 7512
750F 7584 7643 7648 7649 7647 76A4 76E9 77B5 77AB
77B2 77B7 77B6 77B4 77B1 77A8 77F0 78F3 78FD 7902
78FB 78FC 78F2 7905 78F9 78FE 7904 79AB 79A8 7A5C
7A5B 7A56 7A58 7A54 7A5A 7ABE 7AC0 7AC1 7C05 7C0F
7BF2 7C00 7BFF 7BFB 7C0E 7BF4 7C0B 7BF3 7C02 7C09
7C03 7C01 7BF8 7BFD 7C06 7BF0 7BF1 7C10 7C0A 7CE8
7E2D 7E3C 7E42 7E33 9848 7E38 7E2A 7E49 7E40 7E47
7E29 7E4C 7E30 7E3B 7E36 7E44 7E3A 7F45 7F7F 7F7E
7F7D 7FF4 7FF2 802C 81BB 81C4 81CC 81CA 81C5 81C7
81BC 81E9 825B 825A 825C 8583 8580 858F 85A7 8595
85A0 858B 85A3 857B 85A4 859A 859E 8577 857C 8589
85A1 857A 8578 8557 858E 8596 8586 858D 8599 859D
8581 85A2 8582 8588 8585 8579 8576 8598 8590 859F
8668 87BE 87AA 87AD 87C5 87B0 87AC 87B9 87B5 87BC
87AE 87C9 87C3 87C2 87CC 87B7 87AF 87C4 87CA 87B4
87B6 87BF 87B8 87BD 87DE 87B2 8935 8933 893C 893E
8941 8952 8937 8942 89AD 89AF 89AE 89F2 89F3 8B1E
8B18 8B16 8B11 8B05 8B0B 8B22 8B0F 8B12 8B15 8B07
8B0D 8B08 8B06 8B1C 8B13 8B1A 8C4F 8C70 8C72 8C71
8C6F 8C95 8C94 8CF9 8D6F 8E4E 8E4D 8E53 8E50 8E4C
8E47 8F43 8F40 9085 907E 9138 919A 91A2 919B 9199
919F 91A1 919D 91A0 93A1 9383 93AF 9364 9356 9347
937C 9358 935C 9376 9349 9350 9351 9360 936D 938F
934C 936A 9379 9357 9355 9352 934F 9371 9377 937B
9361 935E 9363 9367 9380 934E 9359 95C7 95C0 95C9
95C3 95C5 95B7 96AE 96B0 96AC 9720 971F 9718 971D
9719 979A 97A1 979C 979E 979D 97D5 97D4 97F1 9841
9844 984A 9849 9845 9843 9925 992B 992C 992A 9933
9932 992F 992D 9931 9930 9998 99A3 99A1 9A02 99FA
99F4 99F7 99F9 99F8 99F6 99FB 99FD 99FE 99FC 9A03
9ABE 9AFE 9AFD 9B01 9AFC 9B48 9B9A 9BA8 9B9E 9B9B
9BA6 9BA1 9BA5 9BA4 9B86 9BA2 9BA0 9BAF 9D33 9D41
9D67 9D36 9D2E 9D2F 9D31 9D38 9D30 9D45 9D42 9D43
9D3E 9D37 9D40 9D3D 7FF5 9D2D 9E8A 9E89 9E8D 9EB0
9EC8 9EDA 9EFB 9EFF 9F24 9F23 9F22 9F54 9FA0 5131
512D 512E 5698 569C 5697 569A 569D 5699 5970 5B3C
5C69 5C6A 5DC0 5E6D 5E6E 61D8 61DF 61ED 61EE 61F1
61EA 61F0 61EB 61D6 61E9 64FF 6504 64FD 64F8 6501
6503 64FC 6594 65DB 66DA 66DB 66D8 6AC5 6AB9 6ABD
6AE1 6AC6 6ABA 6AB6 6AB7 6AC7 6AB4 6AAD 6B5E 6BC9
6C0B 7007 700C 700D 7001 7005 7014 700E 6FFF 7000
6FFB 7026 6FFC 6FF7 700A 7201 71FF 71F9 7203 71FD
7376 74B8 74C0 74B5 74C1 74BE 74B6 74BB 74C2 7514
7513 765C 7664 7659 7650 7653 7657 765A 76A6 76BD
76EC 77C2 77BA 78FF 790C 7913 7914 7909 7910 7912
7911 79AD 79AC 7A5F 7C1C 7C29 7C19 7C20 7C1F 7C2D
7C1D 7C26 7C28 7C22 7C25 7C30 7E5C 7E50 7E56 7E63
7E58 7E62 7E5F 7E51 7E60 7E57 7E53 7FB5 7FB3 7FF7
7FF8 8075 81D1 81D2 81D0 825F 825E 85B4 85C6 85C0
85C3 85C2 85B3 85B5 85BD 85C7 85C4 85BF 85CB 85CE
85C8 85C5 85B1 85B6 85D2 8624 85B8 85B7 85BE 8669
87E7 87E6 87E2 87DB 87EB 87EA 87E5 87DF 87F3 87E4
87D4 87DC 87D3 87ED 87D8 87E3 87A4 87D7 87D9 8801
87F4 87E8 87DD 8953 894B 894F 894C 8946 8950 8951
8949 8B2A 8B27 8B23 8B33 8B30 8B35 8B47 8B2F 8B3C
8B3E 8B31 8B25 8B37 8B26 8B36 8B2E 8B24 8B3B 8B3D
8B3A 8C42 8C75 8C99 8C98 8C97 8CFE 8D04 8D02 8D00
8E5C 8E62 8E60 8E57 8E56 8E5E 8E65 8E67 8E5B 8E5A
8E61 8E5D 8E69 8E54 8F46 8F47 8F48 8F4B 9128 913A
913B 913E 91A8 91A5 91A7 91AF 91AA 93B5 938C 9392
93B7 939B 939D 9389 93A7 938E 93AA 939E 93A6 9395
9388 9399 939F 938D 93B1 9391 93B2 93A4 93A8 93B4
93A3 93A5 95D2 95D3 95D1 96B3 96D7 96DA 5DC2 96DF
96D8 96DD 9723 9722 9725 97AC 97AE 97A8 97AB 97A4
97AA 97A2 97A5 97D7 97D9 97D6 97D8 97FA 9850 9851
9852 98B8 9941 993C 993A 9A0F 9A0B 9A09 9A0D 9A04
9A11 9A0A 9A05 9A07 9A06 9AC0 9ADC 9B08 9B04 9B05
9B29 9B35 9B4A 9B4C 9B4B 9BC7 9BC6 9BC3 9BBF 9BC1
9BB5 9BB8 9BD3 9BB6 9BC4 9BB9 9BBD 9D5C 9D53 9D4F
9D4A 9D5B 9D4B 9D59 9D56 9D4C 9D57 9D52 9D54 9D5F
9D58 9D5A 9E8E 9E8C 9EDF 9F01 9F00 9F16 9F25 9F2B
9F2A 9F29 9F28 9F4C 9F55 5134 5135 5296 52F7 53B4
56AB 56AD 56A6 56A7 56AA 56AC 58DA 58DD 58DB 5912
5B3D 5B3E 5B3F 5DC3 5E70 5FBF 61FB 6507 6510 650D
6509 650C 650E 6584 65DE 65DD 66DE 6AE7 6AE0 6ACC
6AD1 6AD9 6ACB 6ADF 6ADC 6AD0 6AEB 6ACF 6ACD 6ADE
6B60 6BB0 6C0C 7019 7027 7020 7016 702B 7021 7022
7023 7029 7017 7024 701C 702A 720C 720A 7207 7202
7205 72A5 72A6 72A4 72A3 72A1 74CB 74C5 74B7 74C3
7516 7660 77C9 77CA 77C4 77F1 791D 791B 7921 791C
7917 791E 79B0 7A67 7A68 7C33 7C3C 7C39 7C2C 7C3B
7CEC 7CEA 7E76 7E75 7E78 7E70 7E77 7E6F 7E7A 7E72
7E74 7E68 7F4B 7F4A 7F83 7F86 7FB7 7FFD 7FFE 8078
81D7 81D5 8264 8261 8263 85EB 85F1 85ED 85D9 85E1
85E8 85DA 85D7 85EC 85F2 85F8 85D8 85DF 85E3 85DC
85D1 85F0 85E6 85EF 85DE 85E2 8800 87FA 8803 87F6
87F7 8809 880C 880B 8806 87FC 8808 87FF 880A 8802
8962 895A 895B 8957 8961 895C 8958 895D 8959 8988
89B7 89B6 89F6 8B50 8B48 8B4A 8B40 8B53 8B56 8B54
8B4B 8B55 8B51 8B42 8B52 8B57 8C43 8C77 8C76 8C9A
8D06 8D07 8D09 8DAC 8DAA 8DAD 8DAB 8E6D 8E78 8E73
8E6A 8E6F 8E7B 8EC2 8F52 8F51 8F4F 8F50 8F53 8FB4
9140 913F 91B0 91AD 93DE 93C7 93CF 93C2 93DA 93D0
93F9 93EC 93CC 93D9 93A9 93E6 93CA 93D4 93EE 93E3
93D5 93C4 93CE 93C0 93D2 93E7 957D 95DA 95DB 96E1
9729 972B 972C 9728 9726 97B3 97B7 97B6 97DD 97DE
97DF 985C 9859 985D 9857 98BF 98BD 98BB 98BE 9948
9947 9943 99A6 99A7 9A1A 9A15 9A25 9A1D 9A24 9A1B
9A22 9A20 9A27 9A23 9A1E 9A1C 9A14 9AC2 9B0B 9B0A
9B0E 9B0C 9B37 9BEA 9BEB 9BE0 9BDE 9BE4 9BE6 9BE2
9BF0 9BD4 9BD7 9BEC 9BDC 9BD9 9BE5 9BD5 9BE1 9BDA
9D77 9D81 9D8A 9D84 9D88 9D71 9D80 9D78 9D86 9D8B
9D8C 9D7D 9D6B 9D74 9D75 9D70 9D69 9D85 9D73 9D7B
9D82 9D6F 9D79 9D7F 9D87 9D68 9E94 9E91 9EC0 9EFC
9F2D 9F40 9F41 9F4D 9F56 9F57 9F58 5337 56B2 56B5
56B3 58E3 5B45 5DC6 5DC7 5EEE 5EEF 5FC0 5FC1 61F9
6517 6516 6515 6513 65DF 66E8 66E3 66E4 6AF3 6AF0
6AEA 6AE8 6AF9 6AF1 6AEE 6AEF 703C 7035 702F 7037
7034 7031 7042 7038 703F 703A 7039 7040 703B 7033
7041 7213 7214 72A8 737D 737C 74BA 76AB 76AA 76BE
76ED 77CC 77CE 77CF 77CD 77F2 7925 7923 7927 7928
7924 7929 79B2 7A6E 7A6C 7A6D 7AF7 7C49 7C48 7C4A
7C47 7C45 7CEE 7E7B 7E7E 7E81 7E80 7FBA 7FFF 8079
81DB 81D9 820B 8268 8269 8622 85FF 8601 85FE 861B
8600 85F6 8604 8609 8605 860C 85FD 8819 8810 8811
8817 8813 8816 8963 8966 89B9 89F7 8B60 8B6A 8B5D
8B68 8B63 8B65 8B67 8B6D 8DAE 8E86 8E88 8E84 8F59
8F56 8F57 8F55 8F58 8F5A 908D 9143 9141 91B7 91B5
91B2 91B3 940B 9413 93FB 9420 940F 9414 93FE 9415
9410 9428 9419 940D 93F5 9400 93F7 9407 940E 9416
9412 93FA 9409 93F8 940A 93FF 93FC 940C 93F6 9411
9406 95DE 95E0 95DF 972E 972F 97B9 97BB 97FD 97FE
9860 9862 9863 985F 98C1 98C2 9950 994E 9959 994C
994B 9953 9A32 9A34 9A31 9A2C 9A2A 9A36 9A29 9A2E
9A38 9A2D 9AC7 9ACA 9AC6 9B10 9B12 9B11 9C0B 9C08
9BF7 9C05 9C12 9BF8 9C40 9C07 9C0E 9C06 9C17 9C14
9C09 9D9F 9D99 9DA4 9D9D 9D92 9D98 9D90 9D9B 9DA0
9D94 9D9C 9DAA 9D97 9DA1 9D9A 9DA2 9DA8 9D9E 9DA3
9DBF 9DA9 9D96 9DA6 9DA7 9E99 9E9B 9E9A 9EE5 9EE4
9EE7 9EE6 9F30 9F2E 9F5B 9F60 9F5E 9F5D 9F59 9F91
513A 5139 5298 5297 56C3 56BD 56BE 5B48 5B47 5DCB
5DCF 5EF1 61FD 651B 6B02 6AFC 6B03 6AF8 6B00 7043
7044 704A 7048 7049 7045 7046 721D 721A 7219 737E
7517 766A 77D0 792D 7931 792F 7C54 7C53 7CF2 7E8A
7E87 7E88 7E8B 7E86 7E8D 7F4D 7FBB 8030 81DD 8618
862A 8626 861F 8623 861C 8619 8627 862E 8621 8620
8629 861E 8625 8829 881D 881B 8820 8824 881C 882B
884A 896D 8969 896E 896B 89FA 8B79 8B78 8B45 8B7A
8B7B 8D10 8D14 8DAF 8E8E 8E8C 8F5E 8F5B 8F5D 9146
9144 9145 91B9 943F 943B 9436 9429 943D 943C 9430
9439 942A 9437 942C 9440 9431 95E5 95E4 95E3 9735
973A 97BF 97E1 9864 98C9 98C6 98C0 9958 9956 9A39
9A3D 9A46 9A44 9A42 9A41 9A3A 9A3F 9ACD 9B15 9B17
9B18 9B16 9B3A 9B52 9C2B 9C1D 9C1C 9C2C 9C23 9C28
9C29 9C24 9C21 9DB7 9DB6 9DBC 9DC1 9DC7 9DCA 9DCF
9DBE 9DC5 9DC3 9DBB 9DB5 9DCE 9DB9 9DBA 9DAC 9DC8
9DB1 9DAD 9DCC 9DB3 9DCD 9DB2 9E7A 9E9C 9EEB 9EEE
9EED 9F1B 9F18 9F1A 9F31 9F4E 9F65 9F64 9F92 4EB9
56C6 56C5 56CB 5971 5B4B 5B4C 5DD5 5DD1 5EF2 6521
6520 6526 6522 6B0B 6B08 6B09 6C0D 7055 7056 7057
7052 721E 721F 72A9 737F 74D8 74D5 74D9 74D7 766D
76AD 7935 79B4 7A70 7A71 7C57 7C5C 7C59 7C5B 7C5A
7CF4 7CF1 7E91 7F4F 7F87 81DE 826B 8634 8635 8633
862C 8632 8636 882C 8828 8826 882A 8825 8971 89BF
89BE 89FB 8B7E 8B84 8B82 8B86 8B85 8B7F 8D15 8E95
8E94 8E9A 8E92 8E90 8E96 8E97 8F60 8F62 9147 944C
9450 944A 944B 944F 9447 9445 9448 9449 9446 973F
97E3 986A 9869 98CB 9954 995B 9A4E 9A53 9A54 9A4C
9A4F 9A48 9A4A 9A49 9A52 9A50 9AD0 9B19 9B2B 9B3B
9B56 9B55 9C46 9C48 9C3F 9C44 9C39 9C33 9C41 9C3C
9C37 9C34 9C32 9C3D 9C36 9DDB 9DD2 9DDE 9DDA 9DCB
9DD0 9DDC 9DD1 9DDF 9DE9 9DD9 9DD8 9DD6 9DF5 9DD5
9DDD 9EB6 9EF0 9F35 9F33 9F32 9F42 9F6B 9F95 9FA2
513D 5299 58E8 58E7 5972 5B4D 5DD8 882F 5F4F 6201
6203 6204 6529 6525 6596 66EB 6B11 6B12 6B0F 6BCA
705B 705A 7222 7382 7381 7383 7670 77D4 7C67 7C66
7E95 826C 863A 8640 8639 863C 8631 863B 863E 8830
8832 882E 8833 8976 8974 8973 89FE 8B8C 8B8E 8B8B
8B88 8C45 8D19 8E98 8F64 8F63 91BC 9462 9455 945D
9457 945E 97C4 97C5 9800 9A56 9A59 9B1E 9B1F 9B20
9C52 9C58 9C50 9C4A 9C4D 9C4B 9C55 9C59 9C4C 9C4E
9DFB 9DF7 9DEF 9DE3 9DEB 9DF8 9DE4 9DF6 9DE1 9DEE
9DE6 9DF2 9DF0 9DE2 9DEC 9DF4 9DF3 9DE8 9DED 9EC2
9ED0 9EF2 9EF3 9F06 9F1C 9F38 9F37 9F36 9F43 9F4F
9F71 9F70 9F6E 9F6F 56D3 56CD 5B4E 5C6D 652D 66ED
66EE 6B13 705F 7061 705D 7060 7223 74DB 74E5 77D5
7938 79B7 79B6 7C6A 7E97 7F89 826D 8643 8838 8837
8835 884B 8B94 8B95 8E9E 8E9F 8EA0 8E9D 91BE 91BD
91C2 946B 9468 9469 96E5 9746 9743 9747 97C7 97E5
9A5E 9AD5 9B59 9C63 9C67 9C66 9C62 9C5E 9C60 9E02
9DFE 9E07 9E03 9E06 9E05 9E00 9E01 9E09 9DFF 9DFD
9E04 9EA0 9F1E 9F46 9F74 9F75 9F76 56D4 652E 65B8
6B18 6B19 6B17 6B1A 7062 7226 72AA 77D8 77D9 7939
7C69 7C6B 7CF6 7E9A 7E98 7E9B 7E99 81E0 81E1 8646
8647 8648 8979 897A 897C 897B 89FF 8B98 8B99 8EA5
8EA4 8EA3 946E 946D 946F 9471 9473 9749 9872 995F
9C68 9C6E 9C6D 9E0B 9E0D 9E10 9E0F 9E12 9E11 9EA1
9EF5 9F09 9F47 9F78 9F7B 9F7A 9F79 571E 7066 7C6F
883C 8DB2 8EA6 91C3 9474 9478 9476 9475 9A60 9C74
9C73 9C71 9C75 9E14 9E13 9EF6 9F0A 9FA4 7068 7065
7CF7 866A 883E 883D 883F 8B9E 8C9C 8EA9 8EC9 974B
9873 9874 98CC 9961 99AB 9A64 9A66 9A67 9B24 9E15
9E17 9F48 6207 6B1E 7227 864C 8EA8 9482 9480 9481
9A69 9A68 9B2E 9E19 7229 864B 8B9F 9483 9C79 9EB7
7675 9A6B 9C7A 9E1D 7069 706A 9EA4 9F7E 9F49 9F98
__END__

=head1 NAME

Unicode::Collate::CJK::Big5 - weighting CJK Unified Ideographs
for Unicode::Collate

=head1 SYNOPSIS

    use Unicode::Collate;
    use Unicode::Collate::CJK::Big5;

    my $collator = Unicode::Collate->new(
        overrideCJK => \&Unicode::Collate::CJK::Big5::weightBig5
    );

=head1 DESCRIPTION

C<Unicode::Collate::CJK::Big5> provides C<weightBig5()>,
that is adequate for C<overrideCJK> of C<Unicode::Collate>
and makes tailoring of CJK Unified Ideographs in the order
of CLDR's big5han ordering.

=head1 SEE ALSO

=over 4

=item CLDR - Unicode Common Locale Data Repository

L<http://cldr.unicode.org/>

=item Unicode Locale Data Markup Language (LDML) - UTS #35

L<http://www.unicode.org/reports/tr35/>

=item L<Unicode::Collate>

=item L<Unicode::Collate::Locale>

=back

=cut
